/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.mapgenerator;

import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;

public class BasinNode {
    final int x;
    final int z;
    final int value;
    final double decay;
    private static final double[] LOGTABLE = BasinNode.makeLogTable();
    private static final double[] logtable = BasinNode.makeLogTable();

    public BasinNode(int x, int y, int value, double decay) {
        this.x = x;
        this.z = y;
        this.value = value;
        this.decay = decay;
    }

    public double getRelativeWeakness(int range) {
        double effect = (double)range * this.decay;
        return range * range;
    }

    public double getWeaknessAt(double atx, double aty) {
        double xdisplace = ((double)this.x - atx) * this.decay;
        double ydisplace = ((double)this.z - aty) * this.decay;
        return Math.min(xdisplace * xdisplace + ydisplace * ydisplace, 1.0);
    }

    public static int summateEffect(BasinNode[] n, ChunkTile t) {
        double effect = 0.0;
        double sum = 0.0;
        for (int i = 0; i < n.length; ++i) {
            if (n[i].x == t.tx && n[i].z == t.tz) {
                return n[i].value;
            }
            double weakness = n[i].getWeaknessAt(t.tx, t.tz);
            double power = 1.0 / (weakness * weakness);
            sum += power;
            effect += Math.max((double)n[i].value * power, 0.0);
        }
        return (int)(effect / sum);
    }

    public static double summateEffect(BasinNode[] n, ChunkTile t, double scale) {
        double effect = 0.0;
        double sum = 0.0;
        for (int i = 0; i < n.length; ++i) {
            double x = (double)t.tx * scale;
            double z = (double)t.tz * scale;
            if (n[i].x == (int)x && n[i].z == (int)z) {
                return n[i].value;
            }
            double weakness = n[i].getWeaknessAt(x, z);
            double power = 1.0 / (weakness * weakness);
            sum += power;
            effect += Math.max((double)n[i].value * power, 0.0);
        }
        return effect / sum;
    }

    private static double[] makeLogTable() {
        double[] out = new double[31];
        for (int i = 0; i < out.length; ++i) {
            out[i] = Math.pow(10.0, (double)(i - 15) / 10.0);
        }
        return out;
    }

    public static double getLogScaled(int in) {
        return logtable[in + 15];
    }

    public String toString() {
        return "    [x=" + this.x + ", z=" + this.z + ", val=" + this.value + ", decay=" + this.decay + "] ";
    }

    public String briefString() {
        return "    [x=" + this.x + ", z=" + this.z + "] ";
    }
}

