/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.mapgenerator;

import jaredbgreat.climaticbiome.configuration.ClimaticWorldSettings;
import jaredbgreat.climaticbiome.generation.mapgenerator.BasinNode;
import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;
import jaredbgreat.climaticbiome.generation.mapgenerator.SizeScale;
import jaredbgreat.climaticbiome.util.NoiseMap;
import jaredbgreat.climaticbiome.util.SpatialHash;

public class LandmassMaker {
    SpatialHash random;
    int regx;
    int regz;
    int size;
    SizeScale scale;
    double currentScale;
    BasinNode[] basins;
    int xoff;
    int zoff;

    LandmassMaker(int rx, int ry, SpatialHash rand, BasinNode[] basinAr, SizeScale sc, int startW, int xoffIn, int zoffIn) {
        this.random = rand;
        this.size = startW * sc.whole;
        this.regx = rx;
        this.regz = ry;
        this.scale = sc;
        this.currentScale = 1.0;
        this.basins = basinAr;
        this.xoff = xoffIn;
        this.zoff = zoffIn;
    }

    public ChunkTile[] generate(ClimaticWorldSettings settings) {
        int j;
        int i;
        double beachThreshold = 0.7;
        ChunkTile[] out = new ChunkTile[this.size * this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            for (int j2 = 0; j2 < this.size; ++j2) {
                out[i2 * this.size + j2] = new ChunkTile(i2, j2, this.xoff, this.zoff);
            }
        }
        NoiseMap heightmaker = new NoiseMap(this.random, this.size, 16 * this.scale.whole, 1.0, this.regx, this.regz);
        double[][] heights = heightmaker.process(0);
        for (i = 0; i < this.size; ++i) {
            for (j = 0; j < this.size; ++j) {
                out[i * this.size + j].height = this.edgeFix(out[i * this.size + j], BasinNode.summateEffect(this.basins, out[i * this.size + j], this.scale.inv));
                out[i * this.size + j].val = (int)out[i * this.size + j].height;
                out[i * this.size + j].height /= 10.0;
                out[i * this.size + j].height = (out[i * this.size + j].height + heights[i][j] / 2.0 + 0.5) * out[i * this.size + j].height + heights[i][j];
            }
        }
        for (i = 0; i < this.size; ++i) {
            for (j = 0; j < this.size; ++j) {
                if (out[i * this.size + j].height > 0.6) {
                    out[i * this.size + j].rlBiome = 1;
                    out[i * this.size + j].beach = true;
                    continue;
                }
                out[i * this.size + j].rlBiome = 0;
            }
        }
        return out;
    }

    protected double edgeFix(ChunkTile t, double val) {
        if (t.x < 10 * this.scale.whole) {
            val += (double)((t.x - 10 * this.scale.whole) / (2 * this.scale.whole));
        } else if (t.x >= this.size - 10 * this.scale.whole) {
            val -= (double)((t.x - this.size + 10 * this.scale.whole) / (2 * this.scale.whole));
        }
        if (t.z < 10 * this.scale.whole) {
            val += (double)((t.z - 10 * this.scale.whole) / (2 * this.scale.whole));
        } else if (t.z >= this.size - 10 * this.scale.whole) {
            val -= (double)((t.z - this.size + 10 * this.scale.whole) / (2 * this.scale.whole));
        }
        return val;
    }
}

