/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.mapgenerator;

import jaredbgreat.climaticbiome.configuration.ClimaticWorldSettings;
import jaredbgreat.climaticbiome.generation.biome.BiomeClimateTable;
import jaredbgreat.climaticbiome.generation.biome.IBiomeSpecifier;
import jaredbgreat.climaticbiome.generation.cache.Cache;
import jaredbgreat.climaticbiome.generation.cache.Coords;
import jaredbgreat.climaticbiome.generation.cache.MutableCoords;
import jaredbgreat.climaticbiome.generation.map.IRegionMap;
import jaredbgreat.climaticbiome.generation.mapgenerator.BasinNode;
import jaredbgreat.climaticbiome.generation.mapgenerator.BiomeBasin;
import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;
import jaredbgreat.climaticbiome.generation.mapgenerator.ClimateNode;
import jaredbgreat.climaticbiome.generation.mapgenerator.LandmassMaker;
import jaredbgreat.climaticbiome.generation.mapgenerator.Region;
import jaredbgreat.climaticbiome.generation.mapgenerator.RiverMaker;
import jaredbgreat.climaticbiome.generation.mapgenerator.SizeScale;
import jaredbgreat.climaticbiome.generation.mapgenerator.SurvivalIslandMaker;
import jaredbgreat.climaticbiome.generation.mapgenerator.TerrainPrimer;
import jaredbgreat.climaticbiome.generation.mapgenerator.WaterworldMaker;
import jaredbgreat.climaticbiome.util.NoiseMap;
import jaredbgreat.climaticbiome.util.SpatialHash;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.world.World;

public class MapMaker {
    IBiomeSpecifier specifier;
    public static final int CSIZE = 16;
    public static final int RSIZE = 256;
    public static final int RADIUS = 128;
    public static final int SQRADIUS = 16384;
    public final int rend;
    ClimaticWorldSettings settings;
    private final Cache<Region> regionCache = new Cache(32);
    private MutableCoords regionCoords = new MutableCoords();
    private MutableCoords chunkCoords = new MutableCoords();
    private ClimateNode[] height;
    private BiomeBasin[][] subbiomes;
    public final SpatialHash chunkNoise;
    public final SpatialHash regionNoise;
    public final SpatialHash biomeNoise;
    public final SizeScale scale;
    private int xoff;
    private int zoff;
    private ChunkTile[] premap;

    public MapMaker(SpatialHash chunkNoise, SpatialHash regionNoise, SpatialHash biomeNoise, ClimaticWorldSettings settings) {
        this.chunkNoise = chunkNoise;
        this.regionNoise = regionNoise;
        this.biomeNoise = biomeNoise;
        this.settings = settings;
        this.scale = settings.regionSize;
        this.specifier = BiomeClimateTable.getClimateTable(settings);
        this.rend = 256 * settings.regionSize.whole - 2;
    }

    private int[] findRegion(int x, int z) {
        int[] out = new int[]{x / 256, z / 256};
        return out;
    }

    private Region[] findRegions(int x, int z) {
        Region[] out = new Region[9];
        int index = 0;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                this.regionCoords.init(x + i, z + j);
                out[index] = this.regionCache.get(this.regionCoords);
                if (out[index] == null) {
                    out[index] = new Region(x + i, z + j, this.regionNoise, this.settings);
                    this.regionCache.add(out[index]);
                } else {
                    out[index].use();
                }
                ++index;
            }
        }
        return out;
    }

    public void generate(IRegionMap datamap, World world, boolean altChunks) {
        int i;
        int i2;
        Coords coords = datamap.getCoords();
        this.xoff = (coords.getX() * 256 - 128) * this.scale.whole;
        this.zoff = (coords.getZ() * 256 - 128) * this.scale.whole;
        Region[] regions = this.findRegions(coords.getX(), coords.getZ());
        ArrayList<BasinNode> basins = new ArrayList<BasinNode>();
        ArrayList<ClimateNode> temp = new ArrayList<ClimateNode>();
        ArrayList<ClimateNode> wet = new ArrayList<ClimateNode>();
        for (Region region : regions) {
            basins.addAll(Arrays.asList(region.basins));
            temp.addAll(Arrays.asList(region.temp));
            wet.addAll(Arrays.asList(region.wet));
        }
        BasinNode[] basinAr = basins.toArray(new BasinNode[basins.size()]);
        ClimateNode[] tempAr = temp.toArray(new ClimateNode[temp.size()]);
        ClimateNode[] wetAr = wet.toArray(new ClimateNode[wet.size()]);
        SpatialHash random = this.chunkNoise;
        this.makeLandmass(basinAr, coords.getX(), coords.getZ(), random);
        NoiseMap climateMaker = new NoiseMap(this.chunkNoise, 256 * this.scale.whole, 32 * this.scale.whole, 2.0, coords.getX(), coords.getZ());
        double[][] climateNoise = climateMaker.process(128);
        double[] doubleNoise = this.averageNoise(this.premap, this.makeDoubleNoise(random, 1));
        for (i2 = 0; i2 < this.premap.length; ++i2) {
            this.premap[i2].temp = (int)Math.max(Math.min(ClimateNode.summateEffect(tempAr, this.premap[i2], doubleNoise[i2], this.scale.inv) + climateNoise[i2 / (256 * this.scale.whole)][i2 % (256 * this.scale.whole)], 24.0), 0.0);
        }
        climateNoise = climateMaker.process(129);
        doubleNoise = this.averageNoise(this.premap, this.makeDoubleNoise(random, 2));
        for (i2 = 0; i2 < this.premap.length; ++i2) {
            this.premap[i2].wet = (int)Math.max(Math.min(ClimateNode.summateEffect(wetAr, this.premap[i2], doubleNoise[i2], this.scale.inv) + climateNoise[i2 / (256 * this.scale.whole)][i2 % (256 * this.scale.whole)], 9.0), 0.0);
        }
        int[] noise = this.refineNoise10(this.makeNoise(random, 4), this.premap);
        for (int i3 = 0; i3 < this.premap.length; ++i3) {
            this.premap[i3].noiseVal = noise[i3];
        }
        if (this.settings.hasRivers && this.settings.mode < 3) {
            RiverMaker rm = new RiverMaker(this, random.longFor(coords.getX(), coords.getZ(), 16), regions[4], coords.getX(), coords.getZ(), this.scale);
            rm.build();
        }
        if (this.settings.forceWhole) {
            this.makeBiomesWhole(this.premap, random.getRandomAt(coords.getX(), coords.getZ(), 3));
        } else {
            this.makeBiomes(this.premap, random.getRandomAt(coords.getX(), coords.getZ(), 3));
        }
        int start = 256 * this.scale.whole * 2 + 2;
        int end = this.premap.length - start;
        for (i = start; i < end; ++i) {
            this.thinBeach(this.premap[i]);
        }
        for (i = start; i < end; ++i) {
            this.makeCoast(this.premap[i]);
        }
        for (i = 0; i < this.premap.length; ++i) {
            this.premap[i].rlBiome = (int)this.specifier.getBiome(this.premap[i]);
            datamap.setBiomeExpress(this.premap[i].rlBiome, i);
        }
        if (altChunks) {
            TerrainPrimer terrainPrimer = new TerrainPrimer();
            terrainPrimer.processTerrain(this.premap, datamap, climateMaker, this.scale, this.settings);
        }
    }

    private void makeLandmass(BasinNode[] basins, int cx, int cz, SpatialHash random) {
        LandmassMaker maker;
        switch (this.settings.mode) {
            case 1: 
            case 2: {
                maker = new LandmassMaker(cx, cz, random, basins, this.scale, 256, this.xoff, this.zoff);
                break;
            }
            case 3: {
                maker = new WaterworldMaker(cx, cz, random, basins, this.scale, 256, this.xoff, this.zoff);
                break;
            }
            case 4: {
                maker = new SurvivalIslandMaker(cx, cz, random, basins, this.scale, 256, this.xoff, this.zoff);
                break;
            }
            default: {
                maker = new LandmassMaker(cx, cz, random, basins, this.scale, 256, this.xoff, this.zoff);
            }
        }
        this.premap = maker.generate(this.settings);
    }

    public ChunkTile getTile(ChunkTile[] premap, int x, int y) {
        int index = x * 256 + y;
        if (index >= premap.length) {
            return null;
        }
        return premap[x * 256 + y];
    }

    protected int[][] makeNoise(SpatialHash random, int t) {
        int[][] noise = new int[256 * this.scale.whole + 2][256 * this.scale.whole + 2];
        for (int i = 0; i < 256 * this.scale.whole + 2; ++i) {
            for (int j = 0; j < 256 * this.scale.whole + 2; ++j) {
                noise[i][j] = SpatialHash.absModulus(random.intFor(i + this.xoff, j + this.zoff, t), 2);
            }
        }
        return noise;
    }

    protected int[] refineNoise(ChunkTile[] premap, int[][] noise, int times) {
        int[][] out = noise;
        for (int i = times; i > 0; --i) {
            out = this.refineNoise2(premap, out);
        }
        return this.refineNoise(premap, out);
    }

    protected int[] refineNoise(ChunkTile[] premap, int[][] noise) {
        int[] out = new int[premap.length];
        for (int i = 1; i < 256 * this.scale.whole + 1; ++i) {
            for (int j = 1; j < 256 * this.scale.whole + 1; ++j) {
                out[(j - 1) * 256 * this.scale.whole + (i - 1)] = this.refineCell(premap, noise, i, j);
            }
        }
        return out;
    }

    protected int[][] refineNoise2(ChunkTile[] premap, int[][] noise) {
        int[][] out = new int[noise.length][noise[0].length];
        for (int i = 1; i < 256 * this.scale.whole + 1; ++i) {
            for (int j = 1; j < 256 * this.scale.whole + 1; ++j) {
                out[i][j] = this.refineCell(premap, noise, i, j);
            }
        }
        return out;
    }

    public int refineCell(ChunkTile[] premap, int[][] noise, int x, int y) {
        int sum = 0;
        for (int i = x - 1; i <= x + 1; ++i) {
            for (int j = y - 1; j <= y + 1; ++j) {
                sum += noise[i][j];
            }
        }
        if (sum < premap[(y - 1) * 256 * this.scale.whole + (x - 1)].val) {
            return 0;
        }
        return 1;
    }

    private double[][] makeDoubleNoise(SpatialHash random, int t) {
        double[][] noise = new double[256 * this.scale.whole + 4][256 * this.scale.whole + 4];
        for (int i = 0; i < 256 * this.scale.whole + 2; ++i) {
            for (int j = 0; j < 256 * this.scale.whole + 2; ++j) {
                noise[i][j] = random.doubleFor(i + this.xoff, j + this.zoff, t) / 5.0 - 0.1;
            }
        }
        return noise;
    }

    public double[] averageNoise(ChunkTile[] premap, double[][] noise) {
        double[] out = new double[premap.length];
        for (int i = 2; i < 256 * this.scale.whole + 2; ++i) {
            for (int j = 2; j < 256 * this.scale.whole + 2; ++j) {
                out[(j - 2) * 256 * this.scale.whole + (i - 2)] = this.averageNoise(noise, i, j);
            }
        }
        return out;
    }

    public double averageNoise(double[][] noise, int x, int y) {
        double sum = 0.0;
        for (int i = x - 2; i <= x + 2; ++i) {
            for (int j = y - 2; j <= y + 2; ++j) {
                sum += noise[i][j];
            }
        }
        return sum / 9.0;
    }

    public void makeBiomes(ChunkTile[] premap, SpatialHash.RandomAt random) {
        int across;
        int size = this.settings.biomeSize;
        int down = across = 256 * this.scale.whole / size;
        this.subbiomes = new BiomeBasin[across][down];
        for (int i = 0; i < across; ++i) {
            for (int j = 0; j < down; ++j) {
                this.subbiomes[i][j] = new BiomeBasin(i * size + random.nextInt(size), j * size + random.nextInt(size), random.nextInt() | 0xFF000000, 1.0 + random.nextDouble());
            }
        }
        for (ChunkTile tile : premap) {
            BiomeBasin.summateEffect(this.subbiomes, tile);
        }
    }

    public void makeBiomesWhole(ChunkTile[] premap, SpatialHash.RandomAt random) {
        int across;
        int size = this.settings.biomeSize;
        int down = across = 256 * this.scale.whole / size;
        this.subbiomes = new BiomeBasin[across][down];
        for (int i = 0; i < across; ++i) {
            for (int j = 0; j < down; ++j) {
                this.subbiomes[i][j] = new BiomeBasin(i * size + random.nextInt(size), j * size + random.nextInt(size), random.nextInt() | 0xFF000000, 1.0 + random.nextDouble(), this);
            }
        }
        for (ChunkTile tile : premap) {
            ChunkTile basis = BiomeBasin.summateForCenter(this.subbiomes, tile);
            tile.biomeSeed = basis.biomeSeed;
            tile.wet = basis.wet;
            tile.temp = basis.temp;
        }
    }

    private int[] refineBasicNoise(int[][] noise, ChunkTile[] premap) {
        int[] out = new int[premap.length];
        for (int i = 1; i < 256 * this.scale.whole + 1; ++i) {
            for (int j = 1; j < 256 * this.scale.whole + 1; ++j) {
                out[(j - 1) * 256 * this.scale.whole + (i - 1)] = this.refineBasicCell(noise, i, j);
            }
        }
        return out;
    }

    private int refineBasicCell(int[][] noise, int x, int y) {
        int sum = 0;
        for (int i = x - 1; i <= x + 1; ++i) {
            for (int j = y - 1; j <= y + 1; ++j) {
                sum += noise[i][j];
            }
        }
        return sum / 5;
    }

    private int[] refineNoise10(int[][] noise, ChunkTile[] premap) {
        int[] out = new int[premap.length];
        for (int i = 1; i < 256 * this.scale.whole + 1; ++i) {
            for (int j = 1; j < 256 * this.scale.whole + 1; ++j) {
                out[(j - 1) * 256 * this.scale.whole + (i - 1)] = this.refineCell10(noise, i, j);
            }
        }
        return out;
    }

    private int refineCell10(int[][] noise, int x, int y) {
        int sum = 0;
        for (int i = x - 1; i <= x + 1; ++i) {
            for (int j = y - 1; j <= y + 1; ++j) {
                sum += noise[i][j];
            }
        }
        return sum;
    }

    private boolean notLand(ChunkTile t) {
        return t.rlBiome == 0;
    }

    void thinBeach(ChunkTile t) {
        if (!t.beach) {
            return;
        }
        int oceans = 0;
        if (this.settings.extraBeaches) {
            for (int i = -2; i < 3; ++i) {
                for (int j = -2; j < 3; ++j) {
                    ChunkTile x = this.premap[(t.getX() + i) * 256 * this.scale.whole + t.getZ() + j];
                    if (!this.notLand(x)) continue;
                    ++oceans;
                }
            }
        } else {
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    ChunkTile x = this.premap[(t.getX() + i) * 256 * this.scale.whole + t.getZ() + j];
                    if (!this.notLand(x)) continue;
                    ++oceans;
                }
            }
        }
        if (oceans < 1) {
            t.beach = false;
            return;
        }
    }

    void makeCoast(ChunkTile t) {
        if (!this.notLand(t) || t.getX() < 1 || t.getX() > this.rend || t.getZ() < 1 || t.getZ() > this.rend) {
            return;
        }
        int beaches = 0;
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                ChunkTile x = this.premap[(t.getX() + i) * 256 * this.scale.whole + t.getZ() + j];
                if (this.notLand(x) || !x.beach) continue;
                ++beaches;
            }
        }
        if (beaches < 1) {
            return;
        }
        t.beach = t.getNoise() < beaches + 4 - (t.getBiomeSeed() >> 14 & 1) + (t.getBiomeSeed() >> 13 & 1);
    }

    public boolean tileIndexIsBad(int x, int z) {
        int index = x * 256 * this.scale.whole + z;
        return index < 0 || index >= this.premap.length;
    }

    public ChunkTile getTile(int x, int y) {
        int index = x * 256 * this.scale.whole + y;
        return this.premap[index];
    }

    public int getXoff() {
        return this.xoff;
    }

    public int getZoff() {
        return this.zoff;
    }
}

