/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.mapgenerator;

import jaredbgreat.climaticbiome.configuration.ClimaticWorldSettings;
import jaredbgreat.climaticbiome.generation.cache.AbstractCachable;
import jaredbgreat.climaticbiome.generation.cache.Coords;
import jaredbgreat.climaticbiome.generation.mapgenerator.BasinNode;
import jaredbgreat.climaticbiome.generation.mapgenerator.ClimateNode;
import jaredbgreat.climaticbiome.util.SpatialHash;

public final class Region
extends AbstractCachable {
    BasinNode[] basins;
    ClimateNode[] temp;
    ClimateNode[] wet;
    int cx;
    int cz;
    static int n = 0;

    public Region(int x, int z, SpatialHash random, ClimaticWorldSettings settings) {
        super(x, z);
        this.cx = x * 256 - 128;
        this.cz = z * 256 - 128;
        switch (settings.mode) {
            case 1: {
                this.makeBasins(5, 10, 15, random.getRandomAt(x, z, 0));
                break;
            }
            case 2: 
            case 3: {
                int num = SpatialHash.absModulus(random.intFor(x, z, -1), 5) + 5;
                this.makeBasins(0, num, 15, random.getRandomAt(x, z, 0));
                break;
            }
            default: {
                this.makeBasins(5, 10, 15, random.getRandomAt(x, z, 0));
            }
        }
        this.makeTempBasins(10, random.getRandomAt(x, z, 1), settings);
        this.makeRainBasins(12, random.getRandomAt(x, z, 2));
        ++n;
    }

    public void finalize() throws Throwable {
        --n;
        super.finalize();
    }

    public Region init(int x, int z, SpatialHash random, ClimaticWorldSettings settings) {
        this.cx = x * 256 - 128;
        this.cz = z * 256 - 128;
        this.makeBasins(5, 10, 15, random.getRandomAt(x, z, 0));
        this.makeTempBasins(10, random.getRandomAt(x, z, 1), settings);
        this.makeRainBasins(12, random.getRandomAt(x, z, 2));
        return this;
    }

    private BasinNode makeBasin(int value, double decay, SpatialHash.RandomAt random) {
        int x = this.cx + random.nextInt(256);
        int z = this.cz + random.nextInt(256);
        return new BasinNode(x, z, value, decay * 1.5);
    }

    private BasinNode makeCentralBasin1(int value, double decay, SpatialHash.RandomAt random) {
        int x = this.cx + random.nextInt(128) + 64;
        int z = this.cz + random.nextInt(128) + 64;
        return new BasinNode(x, z, value, decay * 1.5);
    }

    private BasinNode makeCentralBasin2(int value, double decay, SpatialHash.RandomAt random) {
        int x = this.cx + random.nextInt(204) + 25;
        int y = this.cz + random.nextInt(204) + 25;
        return new BasinNode(x, y, value, decay * 1.5);
    }

    public void makeBasins(int main, int pos, int neg, SpatialHash.RandomAt random) {
        int i;
        this.basins = new BasinNode[main + pos + neg];
        for (i = 0; i < main; ++i) {
            this.basins[i] = this.makeCentralBasin1(10, BasinNode.getLogScaled(-14) / 10.0, random);
        }
        for (i = main; i < pos + main; ++i) {
            this.basins[i] = this.makeCentralBasin2(9, BasinNode.getLogScaled(random.nextInt(5) - 13) / 10.0, random);
        }
        for (i = pos + main; i < this.basins.length; ++i) {
            this.basins[i] = this.makeBasin(0, BasinNode.getLogScaled(random.nextInt(10) - 15) / 10.0, random);
        }
    }

    private void makePoles(ClimateNode[] nodes, SpatialHash.RandomAt random, ClimaticWorldSettings settings) {
        int movex = 0;
        int movez = 0;
        if (settings.mode == 4) {
            movex = random.nextInt(512) - 256;
            movez = random.nextInt(512) - 256;
        }
        int dist = 42 + random.nextInt(64);
        double angle = random.nextDouble() * 2.0 * Math.PI;
        int x = this.cx + 128 + (int)((double)dist * Math.cos(angle)) + movex;
        int y = this.cz + 128 + (int)((double)dist * Math.sin(angle)) + movez;
        nodes[0] = new ClimateNode(x, y, 0, BasinNode.getLogScaled(-14) / 40.0 * 1.5, 0);
        dist = 42 + random.nextInt(64);
        angle = angle + random.nextDouble() * 1.5707963267948966 + 2.356194490192345;
        x = this.cx + 128 + (int)((double)dist * Math.cos(angle));
        y = this.cz + 128 + (int)((double)dist * Math.sin(angle));
        nodes[1] = new ClimateNode(x, y, 25, BasinNode.getLogScaled(-15) / 40.0 * 1.5, 0);
    }

    private void makeColdPoles(ClimateNode[] nodes, SpatialHash.RandomAt random, ClimaticWorldSettings settings) {
        int movex = 0;
        int movez = 0;
        if (settings.mode == 4) {
            movex = random.nextInt(512) - 256;
            movez = random.nextInt(512) - 256;
        }
        int dist = 42 + random.nextInt(64);
        double angle = random.nextDouble() * 2.0 * Math.PI;
        int x = this.cx + 128 + (int)((double)dist * Math.cos(angle)) + movex;
        int y = this.cz + 128 + (int)((double)dist * Math.sin(angle)) + movez;
        nodes[0] = new ClimateNode(x, y, 0, BasinNode.getLogScaled(-14) / 40.0 * 1.5, 0);
        dist = 42 + random.nextInt(64);
        angle = angle + random.nextDouble() * 1.5707963267948966 + 2.356194490192345;
        x = this.cx + 128 + (int)((double)dist * Math.cos(angle));
        y = this.cz + 128 + (int)((double)dist * Math.sin(angle));
        nodes[1] = new ClimateNode(x, y, 50, BasinNode.getLogScaled(-15) / 40.0 * 1.5, 0);
    }

    public void makeTempBasins(int n, SpatialHash.RandomAt random, ClimaticWorldSettings settings) {
        this.temp = new ClimateNode[n + 2];
        this.makePoles(this.temp, random, settings);
        for (int i = 2; i < this.temp.length; ++i) {
            this.temp[i] = new ClimateNode(this.cx + random.nextInt(256), this.cz + random.nextInt(256), random.nextInt(25), BasinNode.getLogScaled(random.nextInt(5) - 12) / 30.0 * 1.5, random.nextInt(3) + 1);
        }
    }

    public void makeRainBasins(int n, SpatialHash.RandomAt random) {
        this.wet = new ClimateNode[n];
        block5: for (int i = 0; i < this.wet.length; ++i) {
            int cycle = i % 3;
            switch (cycle) {
                case 0: {
                    this.wet[i] = new ClimateNode(this.cx + random.nextInt(256), this.cz + random.nextInt(256), 9, BasinNode.getLogScaled(random.nextInt(5) - 15) / 30.0 * 1.5, 0);
                    continue block5;
                }
                case 1: {
                    this.wet[i] = new ClimateNode(this.cx + random.nextInt(256), this.cz + random.nextInt(256), 0, BasinNode.getLogScaled(random.nextInt(5) - 15) / 30.0 * 1.5, 0);
                    continue block5;
                }
                case 2: {
                    this.wet[i] = new ClimateNode(this.cx + random.nextInt(256), this.cz + random.nextInt(256), random.nextInt(10), BasinNode.getLogScaled(random.nextInt(5) - 15) / 10.0 * 1.5, random.nextInt(5));
                }
            }
        }
    }

    public BasinNode[] getBasins(int num, boolean beginning) {
        if (num > this.basins.length) {
            num = this.basins.length;
        }
        BasinNode[] out = new BasinNode[num];
        if (beginning) {
            System.arraycopy(this.basins, 0, out, 0, num);
        } else {
            System.arraycopy(this.basins, this.basins.length - num, out, 0, num);
        }
        return out;
    }

    public String toCoords() {
        return "[" + this.cx / 256 + ", " + this.cz / 256 + "]";
    }

    public String toDataString() {
        StringBuilder builder = new StringBuilder();
        Coords coords = this.getCoords();
        builder.append("\n*************\n");
        builder.append("Region:" + coords.getX() + ", " + coords.getZ() + "\n");
        builder.append("cx = " + this.cx + "; cz = " + this.cz + "\n");
        builder.append("Land Sequences: \n");
        for (BasinNode basinNode : this.basins) {
            builder.append(basinNode.briefString());
            builder.append('\n');
        }
        builder.append("Temp Sequences: \n");
        for (BasinNode basinNode : this.temp) {
            builder.append(basinNode.briefString());
            builder.append('\n');
        }
        builder.append("Wetness Sequences: \n");
        for (BasinNode basinNode : this.wet) {
            builder.append(basinNode.briefString());
            builder.append('\n');
        }
        builder.append("\n*************\n");
        return builder.toString();
    }
}

