/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.mapgenerator;

import jaredbgreat.climaticbiome.generation.mapgenerator.BasinNode;
import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;
import jaredbgreat.climaticbiome.generation.mapgenerator.MapMaker;
import jaredbgreat.climaticbiome.generation.mapgenerator.SizeScale;
import jaredbgreat.climaticbiome.util.Logging;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Random;

public class River {
    final int MAX;
    MapMaker map;
    BasinNode begin;
    BasinNode end;
    int id;
    int x;
    int z;
    int oc;
    int dstx;
    int dstz;
    final Deque<ChunkTile> Q;
    SizeScale scale;
    boolean merged;
    ChunkTile[] possible;

    public River(int riverId, BasinNode high, int endX, int endZ, MapMaker mapIn, SizeScale sc) {
        this.map = mapIn;
        this.id = riverId;
        this.scale = sc;
        this.x = high.x * sc.whole - this.map.getXoff();
        this.z = high.z * sc.whole - this.map.getXoff();
        this.dstx = endX;
        this.dstz = endZ;
        this.MAX = 256 * sc.whole - 2;
        this.Q = new ArrayDeque<ChunkTile>();
        this.merged = false;
        this.begin = high;
        this.possible = new ChunkTile[8];
    }

    public void build(Random r) {
        if (this.map.tileIndexIsBad(this.x, this.z)) {
            Logging.logError("Tried to make river starting out side map! \n\r x = " + this.x + ", z = " + this.z + ", index = " + (this.x * 256 * this.scale.whole + this.z));
            return;
        }
        ChunkTile t = this.map.getTile(this.x, this.z);
        while (!this.shouldEnd(t)) {
            t.river = this.id;
            this.Q.add(t);
            t = this.findNext(t, r);
        }
        for (ChunkTile tr : this.Q) {
            this.makeRiver(tr);
        }
    }

    private ChunkTile findNext(ChunkTile t, Random r) {
        int n = 0;
        this.possible[0] = null;
        if (this.testIfUsed(this.map.getTile(t.x + 1, t.z + 1), n)) {
            ++n;
        }
        if (this.testIfUsed(this.map.getTile(t.x + 1, t.z), n)) {
            ++n;
        }
        if (this.testIfUsed(this.map.getTile(t.x + 1, t.z - 1), n)) {
            ++n;
        }
        if (this.testIfUsed(this.map.getTile(t.x, t.z + 1), n)) {
            ++n;
        }
        if (this.testIfUsed(this.map.getTile(t.x, t.z - 1), n)) {
            ++n;
        }
        if (this.testIfUsed(this.map.getTile(t.x - 1, t.z + 1), n)) {
            ++n;
        }
        if (this.testIfUsed(this.map.getTile(t.x - 1, t.z), n)) {
            ++n;
        }
        if (this.testIfUsed(this.map.getTile(t.x - 1, t.z - 1), n)) {
            ++n;
        }
        ChunkTile out = this.possible[0];
        for (int i = 1; i < n; ++i) {
            if (!(this.getAdjusted(this.possible[i]) > this.getAdjusted(out))) continue;
            out = this.possible[i];
        }
        if (out == null) {
            out = this.map.getTile(t.x + r.nextInt(3) - 1, t.z + r.nextInt(3) - 1);
        }
        return out;
    }

    private double getAdjusted(ChunkTile t) {
        return Math.sqrt((t.x - this.dstx) * (t.x - this.dstx) + (t.z - this.dstz) * (t.z - this.dstz)) / (10.0 + 10.0 * this.scale.fract) - t.height;
    }

    private boolean testIfUsed(ChunkTile t, int n) {
        boolean out;
        boolean bl = out = t.river != this.id;
        if (out) {
            this.possible[n] = t;
        }
        return out;
    }

    private boolean shouldEnd(ChunkTile t) {
        if (this.merged || t == null) {
            return true;
        }
        this.oc = t.height < 0.5 && !t.beach ? ++this.oc : 0;
        this.merged = t.river > 0 && t.river != this.id;
        return t.height < 0.5 && this.oc > 8 * this.scale.whole || this.outOfBounds(t.x, t.z);
    }

    private boolean outOfBounds(int x, int z) {
        return x <= 1 || z <= 1 || x >= this.MAX || z >= this.MAX;
    }

    private void makeRiver(ChunkTile t) {
        this.map.getTile((int)(t.x + 1), (int)t.z).river = this.id;
        this.map.getTile((int)(t.x + 1), (int)(t.z + 1)).river = this.id;
        this.map.getTile((int)t.x, (int)(t.z + 1)).river = this.id;
    }
}

