/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.mapgenerator;

import jaredbgreat.climaticbiome.generation.mapgenerator.BasinNode;
import jaredbgreat.climaticbiome.generation.mapgenerator.MapMaker;
import jaredbgreat.climaticbiome.generation.mapgenerator.Region;
import jaredbgreat.climaticbiome.generation.mapgenerator.River;
import jaredbgreat.climaticbiome.generation.mapgenerator.SizeScale;
import java.util.Random;

public class RiverMaker {
    private final MapMaker map;
    private final Random rand;
    private final BasinNode[] starts;
    private final BasinNode[] ends;
    private final int num;
    private final SizeScale scale;
    private final int regx;
    private final int regz;

    public RiverMaker(MapMaker mapIn, long seed, Region region, int x, int z, SizeScale sc) {
        this.map = mapIn;
        this.rand = new Random(seed);
        this.num = this.rand.nextInt(3 + sc.log) + 5 + sc.whole * sc.log;
        this.starts = region.getBasins(this.num, true);
        this.ends = region.getBasins(this.num, false);
        this.scale = sc;
        this.regx = x;
        this.regz = z;
    }

    public void build() {
        for (int i = 0; i < this.num; ++i) {
            int endZ;
            int endX;
            switch (this.rand.nextInt(4)) {
                case 0: {
                    endX = this.rand.nextInt(256 * this.scale.whole);
                    endZ = 0;
                    break;
                }
                case 1: {
                    endX = this.rand.nextInt(256 * this.scale.whole);
                    endZ = 256 * this.scale.whole;
                    break;
                }
                case 2: {
                    endZ = this.rand.nextInt(256 * this.scale.whole);
                    endX = 0;
                    break;
                }
                case 3: {
                    endZ = this.rand.nextInt(256 * this.scale.whole);
                    endX = 256 * this.scale.whole;
                    break;
                }
                default: {
                    endX = this.ends[i].x;
                    endZ = this.ends[i].z;
                }
            }
            River river = new River(i + 1, this.starts[i], endX, endZ, this.map, this.scale);
            river.build(this.rand);
        }
    }
}

