/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.mapgenerator;

import jaredbgreat.climaticbiome.configuration.ClimaticWorldSettings;
import jaredbgreat.climaticbiome.generation.mapgenerator.BasinNode;
import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;
import jaredbgreat.climaticbiome.generation.mapgenerator.LandmassMaker;
import jaredbgreat.climaticbiome.generation.mapgenerator.SizeScale;
import jaredbgreat.climaticbiome.util.NoiseMap;
import jaredbgreat.climaticbiome.util.SpatialHash;

public class SurvivalIslandMaker
extends LandmassMaker {
    SurvivalIslandMaker(int rx, int ry, SpatialHash rand, BasinNode[] basinAr, SizeScale sc, int startW, int xoffIn, int zoffIn) {
        super(rx, ry, rand, basinAr, sc, startW, xoffIn, zoffIn);
    }

    @Override
    public ChunkTile[] generate(ClimaticWorldSettings settings) {
        int j;
        int i;
        double beachThreshold = 0.7;
        ChunkTile[] out = new ChunkTile[this.size * this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            for (int j2 = 0; j2 < this.size; ++j2) {
                out[i2 * this.size + j2] = new ChunkTile(i2, j2, this.xoff, this.zoff);
            }
        }
        NoiseMap heightmaker = new NoiseMap(this.random, this.size, 16 * this.scale.whole, 1.0, this.regx, this.regz);
        double[][] heights = heightmaker.process(0);
        for (i = 0; i < this.size; ++i) {
            for (j = 0; j < this.size; ++j) {
                out[i * this.size + j].height = this.getFromCenter(out[i * this.size + j], this.scale.inv, settings);
                out[i * this.size + j].val = (int)out[i * this.size + j].height;
                out[i * this.size + j].height /= 10.0;
                out[i * this.size + j].height += Math.abs(heights[i][j]);
            }
        }
        for (i = 0; i < this.size; ++i) {
            for (j = 0; j < this.size; ++j) {
                if (out[i * this.size + j].height > 0.6) {
                    out[i * this.size + j].rlBiome = 1;
                    if (!settings.extraBeaches && !(out[i * this.size + j].height < beachThreshold)) continue;
                    out[i * this.size + j].beach = true;
                    continue;
                }
                out[i * this.size + j].rlBiome = 0;
            }
        }
        return out;
    }

    private double getFromCenter(ChunkTile tile, double inv, ClimaticWorldSettings settings) {
        double x = (double)tile.getTX() * inv;
        double z = (double)tile.getTZ() * inv;
        double dist = Math.sqrt(x * x + z * z);
        return Math.max(0.0, settings.sisize - dist);
    }
}

