/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.mapgenerator;

import jaredbgreat.climaticbiome.configuration.ClimaticWorldSettings;
import jaredbgreat.climaticbiome.generation.map.IRegionMap;
import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;
import jaredbgreat.climaticbiome.generation.mapgenerator.SizeScale;
import jaredbgreat.climaticbiome.util.NoiseMap;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;

public class TerrainPrimer {
    public void processTerrain(ChunkTile[] tiles, IRegionMap datamap, NoiseMap noise, SizeScale scale, ClimaticWorldSettings settings) {
        int[] out = new int[tiles.length];
        double[][] scaleNoise = noise.process(1001);
        double[][] heightNoise = noise.process(8675);
        for (int i = 0; i < tiles.length; ++i) {
            int x = i / (256 * scale.whole);
            int z = i % (256 * scale.whole);
            if (tiles[i].isRiver()) {
                tiles[i].setSteep();
            }
            tiles[i].height = Math.max(heightNoise[x][z] + 1.0, 0.0) * (tiles[i].height - 0.6);
            tiles[i].scale = (float)Math.min(Math.max((scaleNoise[x][z] * 2.0 + 0.4 + tiles[i].height / 2.0) / 5.0, 0.0), tiles[i].height);
            this.lowerRiver(tiles, x, z, scale.whole);
            tiles[i].terrainType.heightAdjuster.processTile(tiles[i], settings);
            if (tiles[i].height > 3.0) {
                tiles[i].height = 4.0 - 1.0 / (tiles[i].height - 1.0);
            }
            datamap.setTerrainExpress(Math.max(Math.min((int)(this.averageHeight(tiles, x, z, scale.whole) * 32.0 + 128.0), 255), 0) + (Math.max(Math.min((int)((double)this.averageScale(tiles, x, z, scale.whole) * 32.0 + 128.0), 255), 0) << 8), i);
        }
    }

    private ChunkTile getTileFromCoords(ChunkTile[] tiles, int x, int z, int size) {
        return tiles[x * 256 * size + z];
    }

    private double averageHeight(ChunkTile[] tiles, int x, int z, int size) {
        ChunkTile center = this.getTileFromCoords(tiles, x, z, size);
        double out = center.height;
        if (x > 0 && x < 255 && z > 0 && z < 255 && !center.isSteep()) {
            out = (this.getTileFromCoords((ChunkTile[])tiles, (int)(x - 1), (int)(z - 1), (int)size).height + this.getTileFromCoords((ChunkTile[])tiles, (int)(x - 1), (int)z, (int)size).height + this.getTileFromCoords((ChunkTile[])tiles, (int)(x - 1), (int)(z + 1), (int)size).height + this.getTileFromCoords((ChunkTile[])tiles, (int)x, (int)(z - 1), (int)size).height + this.getTileFromCoords((ChunkTile[])tiles, (int)(x - 1), (int)(z + 1), (int)size).height + this.getTileFromCoords((ChunkTile[])tiles, (int)(x + 1), (int)(z - 1), (int)size).height + this.getTileFromCoords((ChunkTile[])tiles, (int)(x + 1), (int)z, (int)size).height + this.getTileFromCoords((ChunkTile[])tiles, (int)(x - 1), (int)(z + 1), (int)size).height + center.height * 2.0) / 9.0;
        }
        return out;
    }

    private float averageScale(ChunkTile[] tiles, int x, int z, int size) {
        ChunkTile center = this.getTileFromCoords(tiles, x, z, size);
        float out = center.scale;
        if (x > 0 && x < 255 && z > 0 && z < 255 && !center.isSteep()) {
            out = (this.getTileFromCoords((ChunkTile[])tiles, (int)(x - 1), (int)(z - 1), (int)size).scale + this.getTileFromCoords((ChunkTile[])tiles, (int)(x - 1), (int)z, (int)size).scale + this.getTileFromCoords((ChunkTile[])tiles, (int)(x - 1), (int)(z + 1), (int)size).scale + this.getTileFromCoords((ChunkTile[])tiles, (int)x, (int)(z - 1), (int)size).scale + this.getTileFromCoords((ChunkTile[])tiles, (int)(x - 1), (int)(z + 1), (int)size).scale + this.getTileFromCoords((ChunkTile[])tiles, (int)(x + 1), (int)(z - 1), (int)size).scale + this.getTileFromCoords((ChunkTile[])tiles, (int)(x + 1), (int)z, (int)size).scale + this.getTileFromCoords((ChunkTile[])tiles, (int)(x - 1), (int)(z + 1), (int)size).scale + center.scale) / 9.0f;
        }
        return out;
    }

    private void lowerRiver(ChunkTile[] tiles, int x, int z, int size) {
        ChunkTile center = this.getTileFromCoords(tiles, x, z, size);
        if (x > 0 && x < 255 && z > 0 && z < 255 && !center.isSteep() && (this.getTileFromCoords(tiles, x - 1, z - 1, size).isRiver() || this.getTileFromCoords(tiles, x - 1, z, size).isRiver() || this.getTileFromCoords(tiles, x - 1, z + 1, size).isRiver() || this.getTileFromCoords(tiles, x, z - 1, size).isRiver() || this.getTileFromCoords(tiles, x - 1, z + 1, size).isRiver() || this.getTileFromCoords(tiles, x + 1, z - 1, size).isRiver() || this.getTileFromCoords(tiles, x + 1, z, size).isRiver() || this.getTileFromCoords(tiles, x - 1, z + 1, size).isRiver())) {
            center.height *= 0.5;
        }
    }

    public static void makeFromVanilla(int[] data) {
        int i = 0;
        while (i < data.length) {
            Biome biome = Biome.func_180276_a((int)(data[i] & 0xFF), (Biome)Biomes.field_180279_ad);
            int n = i++;
            data[n] = data[n] | (Math.max(Math.min((int)((double)biome.func_185355_j() * 32.0 + 128.0), 255), 0) << 16) + (Math.max(Math.min((int)((double)biome.func_185360_m() * 32.0 + 128.0), 255), 0) << 24);
        }
    }

    public static void makeFromVanilla(long[] data) {
        int i = 0;
        while (i < data.length) {
            Biome biome = Biome.func_180276_a((int)((int)(data[i] & 0xFFFFFFFFFFFFFFFFL)), (Biome)Biomes.field_180279_ad);
            int n = i++;
            data[n] = data[n] | (Math.max(Math.min((long)((double)biome.func_185355_j() * 32.0 + 128.0), 255L), 0L) << 40) + (Math.max(Math.min((long)((double)biome.func_185360_m() * 32.0 + 128.0), 255L), 0L) << 48);
        }
    }
}

