/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.mapgenerator;

import jaredbgreat.climaticbiome.configuration.ClimaticWorldSettings;
import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;
import java.util.Set;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public enum TerrainType {
    VARIABLE(new VariableHeightAdjuster()),
    VANILLA(new VanillaHeightAdjuster()),
    MOUNTIANOUS(new MountainousHeightAdjuster()),
    STEEP(new VanillaHeightAdjuster()),
    AVERAGED(new AveragedHeightAdjuster()),
    PLATEAU(new PlateauHeightAdjuster()),
    SWAMP(new SwampHeightAdjuster());

    public static final TerrainType[] types;
    public final BiomeHeightAdjuster heightAdjuster;

    private TerrainType(BiomeHeightAdjuster adjuster) {
        this.heightAdjuster = adjuster;
    }

    public static float asymptote(float n, float start, float rate) {
        if (n > start) {
            return start + rate / (n - start + 1.0f);
        }
        return n;
    }

    public static TerrainType fromOrdinal(int number) {
        return types[number];
    }

    static {
        types = TerrainType.values();
    }

    public static final class SwampHeightAdjuster
    implements BiomeHeightAdjuster {
        @Override
        public void processTile(ChunkTile tile, ClimaticWorldSettings settings) {
            Biome biome = Biome.func_180276_a((int)tile.rlBiome, (Biome)Biomes.field_180279_ad);
            tile.height = Math.max(biome.func_185355_j() + 0.2f, 0.0f);
            tile.scale = biome.func_185360_m();
            tile.terrainType = STEEP;
        }
    }

    public static final class PlateauHeightAdjuster
    implements BiomeHeightAdjuster {
        @Override
        public void processTile(ChunkTile tile, ClimaticWorldSettings settings) {
            Biome biome = Biome.func_180276_a((int)tile.rlBiome, (Biome)Biomes.field_180279_ad);
            tile.height = (double)biome.func_185355_j() + tile.height * (double)0.1f;
            tile.scale = biome.func_185360_m() + 0.05f + tile.scale * 0.1f;
            tile.terrainType = STEEP;
        }
    }

    public static final class AveragedHeightAdjuster
    implements BiomeHeightAdjuster {
        @Override
        public void processTile(ChunkTile tile, ClimaticWorldSettings settings) {
            Biome biome = Biome.func_180276_a((int)tile.rlBiome, (Biome)Biomes.field_180279_ad);
            tile.height = (tile.height + (double)biome.func_185355_j()) * 0.5;
            tile.scale = (tile.scale + biome.func_185360_m()) * 0.5f;
        }
    }

    public static final class MountainousHeightAdjuster
    implements BiomeHeightAdjuster {
        @Override
        public void processTile(ChunkTile tile, ClimaticWorldSettings settings) {
            Biome biome = Biome.func_180276_a((int)tile.rlBiome, (Biome)Biomes.field_180279_ad);
            int seed = tile.nextBiomeSeed().getBiomeSeed();
            if ((seed & 1) == 1) {
                tile.height *= 2.0;
            }
            tile.height += (double)biome.func_185355_j();
            tile.scale = (seed & 2) == 2 ? (tile.scale += biome.func_185360_m()) : Math.max(tile.scale, biome.func_185360_m());
            if (settings.bigMountains) {
                tile.height += tile.centrality;
                tile.scale = (float)((double)tile.scale + tile.centrality / 4.0);
            }
        }
    }

    public static final class VanillaHeightAdjuster
    implements BiomeHeightAdjuster {
        @Override
        public void processTile(ChunkTile tile, ClimaticWorldSettings settings) {
            Biome biome = Biome.func_180276_a((int)tile.rlBiome, (Biome)Biomes.field_180279_ad);
            tile.height = biome.func_185355_j();
            tile.scale = biome.func_185360_m();
        }
    }

    public static final class VariableHeightAdjuster
    implements BiomeHeightAdjuster {
        @Override
        public void processTile(ChunkTile tile, ClimaticWorldSettings settings) {
            Biome biome = Biome.func_180276_a((int)tile.rlBiome, (Biome)Biomes.field_180279_ad);
            Set types = BiomeDictionary.getTypes((Biome)biome);
            if (types.contains(BiomeDictionary.Type.MESA)) {
                tile.height = (double)biome.func_185355_j() + tile.height * (double)0.1f;
                tile.scale = biome.func_185360_m() + 0.05f + tile.scale * 0.1f;
                tile.terrainType = STEEP;
            } else if (types.contains(BiomeDictionary.Type.HILLS) || types.contains(BiomeDictionary.Type.MOUNTAIN)) {
                tile.height = (tile.height + (double)biome.func_185355_j()) * 0.5;
                tile.scale = (tile.scale + biome.func_185360_m()) * 0.5f;
            }
        }
    }

    public static interface BiomeHeightAdjuster {
        public void processTile(ChunkTile var1, ClimaticWorldSettings var2);
    }
}

