/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.generation.mapgenerator;

import jaredbgreat.climaticbiome.generation.mapgenerator.BasinNode;
import jaredbgreat.climaticbiome.generation.mapgenerator.ChunkTile;
import jaredbgreat.climaticbiome.generation.mapgenerator.LandmassMaker;
import jaredbgreat.climaticbiome.generation.mapgenerator.SizeScale;
import jaredbgreat.climaticbiome.util.NoiseMap;
import jaredbgreat.climaticbiome.util.SpatialHash;

public class WaterworldMaker
extends LandmassMaker {
    WaterworldMaker(int rx, int ry, SpatialHash rand, BasinNode[] basinAr, SizeScale sc, int startW, int xoffIn, int zoffIn) {
        super(rx, ry, rand, basinAr, sc, startW, xoffIn, zoffIn);
    }

    public ChunkTile[] generate() {
        double beachThreshold = 0.7;
        ChunkTile[] out = new ChunkTile[this.size * this.size];
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                out[i * this.size + j] = new ChunkTile(i, j, this.xoff, this.zoff);
            }
        }
        NoiseMap heightmaker = new NoiseMap(this.random, this.size, 16 * this.scale.whole, 1.0, this.regx, this.regz);
        double[][] heights = heightmaker.process(0);
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                out[i * this.size + j].height = this.edgeFix(out[i * this.size + j], BasinNode.summateEffect(this.basins, out[i * this.size + j], this.scale.inv));
                out[i * this.size + j].val = (int)out[i * this.size + j].height;
                out[i * this.size + j].height /= 20.0;
                out[i * this.size + j].height = (out[i * this.size + j].height + heights[i][j] / 2.0 + 0.5) * out[i * this.size + j].height + heights[i][j];
                out[i * this.size + j].rlBiome = 0;
            }
        }
        return out;
    }
}

