/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;

public class Externalizer {
    private BufferedReader instream;
    private BufferedWriter outstream;
    private static final String baseLocation = "/assets/climaticbiomesjbg/BiomeLists/";
    private static final String outDir = "BiomeConfig";
    private static final String readMeFile = "README.txt";
    private static final String varDir = "BiomeVariants";
    private static final String varFileName = "variants.cfg";
    private static final String[] blists = new String[]{"AplineCold.cfg", "AplineDry.cfg", "AplineWet.cfg", "AplineDryWarm.cfg", "AplineWetWarm.cfg", "AplineDryHot.cfg", "AplineWetHot.cfg", "ChaparralScrub.cfg", "DeepOceanCold.cfg", "DeepOceanCool.cfg", "DeepOceanFrozen.cfg", "DeepOceanHot.cfg", "DeepOceanWarm.cfg", "Desert.cfg", "Forest.cfg", "ForestCool.cfg", "ForestTropical.cfg", "ForestWarm.cfg", "IslandVolcanoes.cfg", "Jungle.cfg", "OceanCold.cfg", "OceanCool.cfg", "OceanFrozen.cfg", "OceanHot.cfg", "OceanWarm.cfg", "Parkland.cfg", "ParklandCool.cfg", "Plains.cfg", "PlainsCold.cfg", "PlainsCool.cfg", "Savanna.cfg", "SpecialIslandCold.cfg", "SpecialIslandCool.cfg", "SpecialIslandDesert.cfg", "SpecialIslandFrozen.cfg", "SpecialIslandTemperate.cfg", "SpecialIslandTropical.cfg", "SpecialIslandWarm.cfg", "SwampCold.cfg", "SwampCool.cfg", "SwampTropical.cfg", "SwampWarm.cfg", "Taiga.cfg", "Tundra.cfg"};
    private static final String[] subdirs = new String[]{"Minecraft", "BiomeOPlenty", "Traverse", "custom", "AbyssalCraft", "AuxiliaryBiomes", "Environs", "Minecraft", "PVJ", "BYG", "DefiledLands", "Redwoods", "NovamTerram", "special"};

    public void copyOut(File confdir) {
        try {
            File outFile;
            File listDir = new File(confdir + File.separator + outDir);
            if (!listDir.exists()) {
                listDir.mkdirs();
            }
            if (!(outFile = new File(confdir + File.separator + outDir + File.separator + readMeFile)).exists()) {
                this.copyReadMe(outFile);
            }
            this.copyLists(listDir);
        }
        catch (Exception e) {
            System.err.println("Error! Failed to write theme README file!");
            e.printStackTrace();
        }
    }

    public void copyLists(File listDir) throws Exception {
        File file;
        for (String sub : subdirs) {
            File dir = new File(listDir + File.separator + sub + File.separator);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            for (String fname : blists) {
                File file2 = new File(dir + File.separator + fname);
                if (file2.exists()) continue;
                System.out.println("Creating file " + file2);
                this.copyBiomeList(file2, sub, fname);
            }
        }
        File dir = new File(listDir + File.separator + varDir + File.separator);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(file = new File(dir + File.separator + varFileName)).exists()) {
            System.out.println("Creating file " + file);
            this.copyBiomeList(file, varDir, varFileName);
        }
    }

    public void copyReadMe(File outFile) throws Exception {
        this.instream = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/assets/climaticbiomesjbg/BiomeLists/README.txt")));
        this.outstream = new BufferedWriter(new FileWriter(outFile));
        if (this.instream != null && this.outstream != null) {
            String line;
            while ((line = this.instream.readLine()) != null) {
                this.outstream.write(line + System.lineSeparator());
            }
        } else {
            System.err.println("Error! Failed to write theme README file!");
        }
        if (this.instream != null) {
            this.instream.close();
        }
        if (this.outstream != null) {
            this.outstream.close();
        }
    }

    public void copyBiomeList(File outFile, String dir, String name) throws Exception {
        this.instream = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(baseLocation + dir + "/" + name)));
        this.outstream = new BufferedWriter(new FileWriter(outFile));
        if (this.instream != null && this.outstream != null) {
            String line;
            while ((line = this.instream.readLine()) != null) {
                this.outstream.write(line + System.lineSeparator());
            }
        } else {
            System.err.println("Error! Failed to write theme README file!");
        }
        if (this.instream != null) {
            this.instream.close();
        }
        if (this.outstream != null) {
            this.outstream.close();
        }
    }
}

