/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.util;

import jaredbgreat.climaticbiome.ClimaticBiomes;
import jaredbgreat.climaticbiome.blocks.itemblocks.ItemMultiblock;
import jaredbgreat.climaticbiome.configuration.ConfigHandler;
import jaredbgreat.climaticbiome.items.ItemPeatBrick;
import jaredbgreat.climaticbiome.util.BlockRegistrar;
import jaredbgreat.climaticbiome.util.IHaveModel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class ItemRegistrar {
    private static final List<Item> ITEMS = new ArrayList<Item>();
    public static ItemPeatBrick peatbrick;

    public static void initItems() {
        ItemRegistrar.registerItems();
    }

    public static void registerItems() {
        IForgeRegistry regs = GameRegistry.findRegistry(Item.class);
        for (Item item : ITEMS) {
            regs.register((IForgeRegistryEntry)item);
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (Item item : ITEMS) {
            if (item instanceof IHaveModel) {
                ((IHaveModel)item).registerModel();
                continue;
            }
            if (item instanceof ItemMultiblock) {
                ClimaticBiomes.proxy.registerMultiRender((ItemMultiblock)item);
                continue;
            }
            ClimaticBiomes.proxy.registerItemRender(item, 0);
        }
        for (Block block : BlockRegistrar.getBlocks()) {
            if (!(block instanceof IHaveModel)) continue;
            ((IHaveModel)block).registerModel();
        }
        ClimaticBiomes.proxy.fixRenders(BlockRegistrar.blockPineNeedles);
    }

    public static void registerMultiModels() {
        for (Item item : ITEMS) {
            if (!(item instanceof ItemMultiblock)) continue;
            ClimaticBiomes.proxy.registerMultiRender((ItemMultiblock)item);
        }
    }

    public static void addItem(Item in) {
        ITEMS.add(in);
    }

    public static void oreDict() {
        OreDictionary.registerOre((String)"logWood", (Block)BlockRegistrar.blockPineLog);
        OreDictionary.registerOre((String)"plankWood", (Block)BlockRegistrar.blockPinePlanks);
        OreDictionary.registerOre((String)"slabWood", (Block)BlockRegistrar.pineHalfSlab);
        OreDictionary.registerOre((String)"treeLeaves", (Block)BlockRegistrar.blockPineNeedles);
        OreDictionary.registerOre((String)"treeSapling", (Block)BlockRegistrar.blockPineSappling);
        if (ConfigHandler.includeVolcano) {
            OreDictionary.registerOre((String)"blockBasalt", (Block)BlockRegistrar.blockBasalt);
            OreDictionary.registerOre((String)"blockVolcanicAsh", (Block)BlockRegistrar.blockAsh);
        }
        if (ConfigHandler.includeSwamps) {
            OreDictionary.registerOre((String)"blockPeat", (Block)BlockRegistrar.blockPeat);
            OreDictionary.registerOre((String)"brickPeat", (Block)BlockRegistrar.blockPeat);
        }
    }

    public static void addRecipes() {
        GameRegistry.addSmelting((Item)((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("climaticbiomesjbg:pine_log"))), (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
    }
}

