/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.climaticbiome.util;

import jaredbgreat.climaticbiome.util.SpatialHash;
import jaredbgreat.climaticbiome.util.Vec2D;

public class NoiseMap {
    int size;
    int interval;
    int currentInterval;
    int regx;
    int regy;
    double[][] field;
    double scale;
    double divisor;
    SpatialHash random;

    public NoiseMap(SpatialHash random, int size, int interval, double scale, int regx, int regy) {
        this.size = size;
        this.interval = interval;
        this.scale = scale;
        this.regx = regx;
        this.regy = regy;
        this.size = size;
        this.random = random;
    }

    public double[][] process(int startz) {
        this.field = new double[this.size][this.size];
        this.currentInterval = this.interval;
        this.divisor = 1.0;
        while (this.currentInterval > 2) {
            this.processOne(startz);
            this.divisor *= 2.0;
            this.currentInterval /= 2;
            startz += 2;
        }
        return this.field;
    }

    private void processOne(int startz) {
        int j;
        int i;
        int nodesX = this.size / this.currentInterval + 1;
        int nodesY = this.size / this.currentInterval + 1;
        Vec2D[][] nodes = new Vec2D[nodesX][nodesY];
        for (i = 0; i < nodesX; ++i) {
            for (j = 0; j < nodesY; ++j) {
                nodes[i][j] = new Vec2D(this.random, this.regx * nodesX - 1 + i, this.regy * nodesY - 1 + j, startz);
            }
        }
        for (i = 0; i < this.size; ++i) {
            for (j = 0; j < this.size; ++j) {
                double[] dArray = this.field[i];
                int n = j;
                dArray[n] = dArray[n] + this.processPoint(nodes, i, j) * this.scale;
            }
        }
    }

    public double processPoint(Vec2D[][] nodes, int x, int y) {
        double out = 0.0;
        double ci = this.currentInterval;
        double dx = this.fullFade(x % this.currentInterval);
        double dy = this.fullFade(y % this.currentInterval);
        int px = x / this.currentInterval;
        int py = y / this.currentInterval;
        out += this.calcLoc(nodes[px][py], new Vec2D(dx, dy), ci);
        out += this.calcLoc(nodes[px + 1][py], new Vec2D(ci - dx, dy), ci);
        out += this.calcLoc(nodes[px + 1][py + 1], new Vec2D(ci - dx, ci - dy), ci);
        out += this.calcLoc(nodes[px][py + 1], new Vec2D(dx, ci - dy), ci);
        out /= (double)this.interval;
        return out /= 2.0;
    }

    private double calcLoc(Vec2D from, Vec2D at, double ci) {
        double dx = at.x / ci;
        double dy = at.y / ci;
        double l = 1.0 - (dx * dx + dy * dy);
        if (l > 0.0) {
            return Vec2D.dot(from, at) * l;
        }
        return 0.0;
    }

    private double fade(double in) {
        return in * in * in * (in * (in * 6.0 - 15.0) + 10.0);
    }

    private double fullFade(double in) {
        return this.fade(in / (double)this.currentInterval) * (double)this.currentInterval;
    }
}

