/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen;

import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LootTableProvider
implements DataProvider {
    private static final Logger logger = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator dataGenerator;
    private final Map<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();

    protected LootTableProvider(DataGenerator dataGenerator) {
        this.dataGenerator = dataGenerator;
    }

    public void m_6865_(HashCache cache) {
        this.tables.clear();
        Path out = this.dataGenerator.m_123916_();
        this.registerTables();
        ValidationContext validator = new ValidationContext(LootContextParamSets.f_81420_, e -> null, this.tables::get);
        this.tables.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validator, (ResourceLocation)name, (LootTable)table));
        Multimap problems = validator.m_79352_();
        if (!problems.isEmpty()) {
            logger.warn("Problems detected for LootTableGenerator: " + this.m_6055_());
            problems.forEach((name, table) -> logger.warn("Found validation problem in {}: {}", name, table));
            throw new IllegalStateException("Failed to validate loot tables, see logs.");
        }
        this.tables.forEach((name, table) -> {
            Path output = LootTableProvider.getPath(out, name);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)LootTables.m_79200_((LootTable)table), (Path)output);
            }
            catch (IOException e) {
                logger.error("Couldn't save loot table {}", (Object)output, (Object)e);
            }
        });
    }

    protected abstract void registerTables();

    protected void registerTable(ResourceLocation name, LootTable table) {
        if (this.tables.put(name, table) != null) {
            throw new IllegalArgumentException("Duplicate loot table registered: " + name);
        }
    }

    private static Path getPath(Path pathIn, ResourceLocation id) {
        return pathIn.resolve("data/" + id.m_135827_() + "/loot_tables/" + id.m_135815_() + ".json");
    }

    public static abstract class BlockLootProvider
    extends LootTableProvider {
        protected static final LootItemCondition.Builder SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
        protected static final LootItemCondition.Builder NO_SILK_TOUCH = SILK_TOUCH.m_81807_();

        protected BlockLootProvider(DataGenerator dataGenerator) {
            super(dataGenerator);
        }

        protected LootPool.Builder singleItem(ItemLike item) {
            return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item));
        }

        protected LootPool.Builder singleItemOr(ItemLike failDrop, LootItemCondition.Builder condition, LootPoolEntryContainer.Builder<?> passDrop) {
            return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)failDrop).m_6509_(condition)).m_7170_(passDrop));
        }

        protected LootPool.Builder singleItemOrSilk(ItemLike silk, LootPoolSingletonContainer.Builder<?> drop) {
            return this.singleItemOr(silk, SILK_TOUCH, (LootPoolEntryContainer.Builder<?>)drop);
        }

        protected LootPool.Builder singleItemOrSilk(ItemLike silk, ItemLike drop) {
            return this.singleItemOrSilk(silk, LootItem.m_79579_((ItemLike)drop));
        }

        protected LootPool.Builder valueRange(ItemLike item, int min, int max) {
            return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))));
        }

        protected LootPool.Builder valueRangeOrSilk(ItemLike silk, ItemLike drop, int min, int max) {
            return this.singleItemOr(silk, SILK_TOUCH, (LootPoolEntryContainer.Builder<?>)LootItem.m_79579_((ItemLike)drop).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))));
        }

        protected LootPool.Builder valueRangeOrSilkWithFortune(ItemLike silk, ItemLike drop, int min, int max) {
            return this.singleItemOr(silk, SILK_TOUCH, (LootPoolEntryContainer.Builder<?>)LootItem.m_79579_((ItemLike)drop).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)));
        }

        protected void register(Block block, LootPool.Builder ... pools) {
            LootTable.Builder builder = LootTable.m_79147_();
            for (LootPool.Builder pool : pools) {
                builder.m_79161_(pool);
            }
            this.register(block, builder);
        }

        protected void register(Block block, LootTable.Builder builder) {
            this.register(block.getRegistryName(), builder);
        }

        protected void register(ResourceLocation name, LootTable.Builder builder) {
            this.registerTable(new ResourceLocation(name.m_135827_(), "blocks/" + name.m_135815_()), builder.m_79165_(LootContextParamSets.f_81421_).m_79167_());
        }
    }
}

