/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.command.admin;

import codechicken.lib.internal.command.EntityTypeArgument;
import codechicken.lib.math.MathHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Enemy;

public class KillAllCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"ccl").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"killall").requires(e -> e.m_6761_(2))).then(Commands.m_82129_((String)"entity", (ArgumentType)EntityTypeArgument.entityType()).executes(ctx -> {
            EntityType<?> entityType = EntityTypeArgument.getEntityType((CommandContext<CommandSourceStack>)ctx, "entity");
            return KillAllCommand.killallForce((CommandContext<CommandSourceStack>)ctx, entityType, e -> Objects.equals(e.m_6095_(), entityType));
        }))).executes(ctx -> KillAllCommand.killallForce((CommandContext<CommandSourceStack>)ctx, null, e -> e instanceof Enemy))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"gracefully").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityTypeArgument.entityType()).executes(ctx -> {
            EntityType<?> entityType = EntityTypeArgument.getEntityType((CommandContext<CommandSourceStack>)ctx, "entity");
            return KillAllCommand.killAllGracefully((CommandContext<CommandSourceStack>)ctx, entityType, e -> Objects.equals(e.m_6095_(), entityType));
        }))).executes(ctx -> KillAllCommand.killAllGracefully((CommandContext<CommandSourceStack>)ctx, null, e -> e instanceof Enemy)))));
    }

    private static int killAllGracefully(CommandContext<CommandSourceStack> ctx, @Nullable EntityType<?> type, Predicate<Entity> predicate) {
        return KillAllCommand.killEntities(ctx, type, predicate, Entity::m_6074_);
    }

    private static int killallForce(CommandContext<CommandSourceStack> ctx, @Nullable EntityType<?> type, Predicate<Entity> predicate) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerLevel world = source.m_81372_();
        return KillAllCommand.killEntities(ctx, type, predicate, arg_0 -> ((ServerLevel)world).removeEntity(arg_0));
    }

    private static int killEntities(CommandContext<CommandSourceStack> ctx, @Nullable EntityType<?> type, Predicate<Entity> predicate, Consumer<Entity> killFunc) {
        if (type == EntityType.f_20532_) {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("ccl.commands.killall.fail.player").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerLevel world = source.m_81372_();
        ServerChunkCache provider = world.m_7726_();
        Object2IntOpenHashMap counts = new Object2IntOpenHashMap();
        counts.defaultReturnValue(0);
        List<Entity> entities = StreamSupport.stream(world.m_142646_().m_142273_().spliterator(), false).filter(Objects::nonNull).filter(predicate).filter(e -> provider.m_5563_(MathHelper.floor(e.m_20185_()) >> 4, MathHelper.floor(e.m_20189_()) >> 4)).collect(Collectors.toList());
        entities.forEach(arg_0 -> KillAllCommand.lambda$killEntities$10(killFunc, (Object2IntMap)counts, arg_0));
        ArrayList<EntityType> order = new ArrayList<EntityType>((Collection<EntityType>)counts.keySet());
        order.sort(Comparator.comparingInt(arg_0 -> ((Object2IntMap)counts).getInt(arg_0)));
        int total = 0;
        for (EntityType t : order) {
            int count = counts.getInt((Object)t);
            String name = t.getRegistryName().toString();
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("ccl.commands.killall.success.line", new Object[]{ChatFormatting.RED + name + ChatFormatting.RESET + " x " + ChatFormatting.AQUA + count}), false);
            total += count;
        }
        if (order.size() == 0) {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("ccl.commands.killall.fail"), false);
        } else if (order.size() > 1) {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("ccl.commands.killall.success", new Object[]{ChatFormatting.AQUA.toString() + total + ChatFormatting.RESET}), false);
        }
        return total;
    }

    private static /* synthetic */ void lambda$killEntities$10(Consumer killFunc, Object2IntMap counts, Entity e) {
        killFunc.accept(e);
        int count = counts.getInt((Object)e.m_6095_());
        counts.put((Object)e.m_6095_(), count + 1);
    }
}

