/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen;

import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LootTableProvider
implements IDataProvider {
    private static final Logger logger = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator dataGenerator;
    private final Map<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();

    protected LootTableProvider(DataGenerator dataGenerator) {
        this.dataGenerator = dataGenerator;
    }

    public void func_200398_a(DirectoryCache cache) {
        this.tables.clear();
        Path out = this.dataGenerator.func_200391_b();
        this.registerTables();
        ValidationTracker validator = new ValidationTracker(LootParameterSets.field_216266_g, e -> null, this.tables::get);
        this.tables.forEach((name, table) -> LootTableManager.func_227508_a_((ValidationTracker)validator, (ResourceLocation)name, (LootTable)table));
        Multimap problems = validator.func_227527_a_();
        if (!problems.isEmpty()) {
            logger.warn("Problems detected for LootTableGenerator: " + this.func_200397_b());
            problems.forEach((name, table) -> logger.warn("Found validation problem in {}: {}", name, table));
            throw new IllegalStateException("Failed to validate loot tables, see logs.");
        }
        this.tables.forEach((name, table) -> {
            Path output = LootTableProvider.getPath(out, name);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)table), (Path)output);
            }
            catch (IOException e) {
                logger.error("Couldn't save loot table {}", (Object)output, (Object)e);
            }
        });
    }

    protected abstract void registerTables();

    protected void registerTable(ResourceLocation name, LootTable table) {
        if (this.tables.put(name, table) != null) {
            throw new IllegalArgumentException("Duplicate loot table registered: " + name);
        }
    }

    private static Path getPath(Path pathIn, ResourceLocation id) {
        return pathIn.resolve("data/" + id.func_110624_b() + "/loot_tables/" + id.func_110623_a() + ".json");
    }

    public static abstract class BlockLootProvider
    extends LootTableProvider {
        protected BlockLootProvider(DataGenerator dataGenerator) {
            super(dataGenerator);
        }

        protected LootPool.Builder singleItem(IItemProvider item) {
            return LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item));
        }

        protected void register(Block block, LootPool.Builder ... pools) {
            LootTable.Builder builder = LootTable.func_216119_b();
            for (LootPool.Builder pool : pools) {
                builder.func_216040_a(pool);
            }
            this.register(block, builder);
        }

        protected void register(Block block, LootTable.Builder builder) {
            this.register(block.getRegistryName(), builder);
        }

        protected void register(ResourceLocation name, LootTable.Builder builder) {
            this.registerTable(new ResourceLocation(name.func_110624_b(), "blocks/" + name.func_110623_a()), builder.func_216039_a(LootParameterSets.field_216267_h).func_216038_b());
        }
    }
}

