/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.command.admin;

import codechicken.lib.internal.command.EntityTypeArgument;
import codechicken.lib.math.MathHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.IMob;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;

public class KillAllCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"ccl").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"killall").requires(e -> e.func_197034_c(2))).then(Commands.func_197056_a((String)"entity", (ArgumentType)EntityTypeArgument.entityType()).executes(ctx -> {
            EntityType<?> entityType = EntityTypeArgument.getEntityType((CommandContext<CommandSource>)ctx, "entity");
            return KillAllCommand.killallForce((CommandContext<CommandSource>)ctx, e -> e.func_200600_R().equals(entityType));
        }))).executes(ctx -> KillAllCommand.killallForce((CommandContext<CommandSource>)ctx, e -> e instanceof IMob))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"gracefully").then(Commands.func_197056_a((String)"entity", (ArgumentType)EntityTypeArgument.entityType()).executes(ctx -> {
            EntityType<?> entityType = EntityTypeArgument.getEntityType((CommandContext<CommandSource>)ctx, "entity");
            return KillAllCommand.killAllGracefully((CommandContext<CommandSource>)ctx, e -> e.func_200600_R().equals(entityType));
        }))).executes(ctx -> KillAllCommand.killAllGracefully((CommandContext<CommandSource>)ctx, e -> e instanceof IMob)))));
    }

    private static int killAllGracefully(CommandContext<CommandSource> ctx, Predicate<Entity> predicate) {
        return KillAllCommand.killEntities(ctx, predicate, Entity::func_174812_G);
    }

    private static int killallForce(CommandContext<CommandSource> ctx, Predicate<Entity> predicate) {
        CommandSource source = (CommandSource)ctx.getSource();
        ServerWorld world = source.func_197023_e();
        return KillAllCommand.killEntities(ctx, predicate, arg_0 -> ((ServerWorld)world).func_217467_h(arg_0));
    }

    private static int killEntities(CommandContext<CommandSource> ctx, Predicate<Entity> predicate, Consumer<Entity> killFunc) {
        CommandSource source = (CommandSource)ctx.getSource();
        ServerWorld world = source.func_197023_e();
        ServerChunkProvider provider = world.func_72863_F();
        Object2IntOpenHashMap counts = new Object2IntOpenHashMap();
        counts.defaultReturnValue(0);
        world.getEntities().filter(predicate).filter(e -> provider.func_73149_a(MathHelper.floor(e.func_226277_ct_()) >> 4, MathHelper.floor(e.func_226281_cx_()) >> 4)).forEach(arg_0 -> KillAllCommand.lambda$killEntities$10(killFunc, (Object2IntMap)counts, arg_0));
        ArrayList<EntityType> order = new ArrayList<EntityType>((Collection<EntityType>)counts.keySet());
        order.sort(Comparator.comparingInt(arg_0 -> ((Object2IntMap)counts).getInt(arg_0)));
        int total = 0;
        for (EntityType type : order) {
            int count = counts.getInt((Object)type);
            String name = type.getRegistryName().toString();
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("ccl.commands.killall.success.line", new Object[]{TextFormatting.RED + name + TextFormatting.RESET + " x " + TextFormatting.AQUA + count}), false);
            total += count;
        }
        if (order.size() == 0) {
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("ccl.commands.killall.fail"), false);
        } else if (order.size() > 1) {
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("ccl.commands.killall.success", new Object[]{TextFormatting.AQUA.toString() + total + TextFormatting.RESET}), false);
        }
        return total;
    }

    private static /* synthetic */ void lambda$killEntities$10(Consumer killFunc, Object2IntMap counts, Entity e) {
        killFunc.accept(e);
        int count = counts.getInt((Object)e.func_200600_R());
        counts.put((Object)e.func_200600_R(), count + 1);
    }
}

