/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.vec.Matrix4;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CCRenderEventHandler {
    public static int renderTime;
    public static float renderFrame;
    private static boolean hasInit;

    public static void init() {
        if (!hasInit) {
            MinecraftForge.EVENT_BUS.register((Object)new CCRenderEventHandler());
            hasInit = true;
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++renderTime;
        }
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            renderFrame = event.renderTickTime;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onBlockHighlight(DrawHighlightEvent.HighlightBlock event) {
        BlockRayTraceResult hit = event.getTarget();
        if (hit instanceof CuboidRayTraceResult) {
            CuboidRayTraceResult cuboidHit = (CuboidRayTraceResult)hit;
            event.setCanceled(true);
            Matrix4 mat = new Matrix4(event.getMatrix());
            mat.translate((Vector3i)cuboidHit.func_216350_a());
            RenderUtils.bufferHitbox(mat, event.getBuffers(), event.getInfo(), cuboidHit.cuboid6);
        }
    }

    static {
        hasInit = false;
    }
}

