/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.consecration.api.ConsecrationApi;
import top.theillusivec4.consecration.client.ConsecrationRenderer;
import top.theillusivec4.consecration.common.ConsecrationConfig;
import top.theillusivec4.consecration.common.ConsecrationSeed;
import top.theillusivec4.consecration.common.HolyRegistry;
import top.theillusivec4.consecration.common.capability.UndyingCapability;
import top.theillusivec4.consecration.common.registry.ConsecrationRegistry;
import top.theillusivec4.consecration.common.trigger.SmiteTrigger;

@Mod(value="consecration")
public class Consecration {
    public static final String MODID = "consecration";
    public static final Logger LOGGER = LogManager.getLogger();

    public Consecration() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::imcProcess);
        eventBus.addListener(this::config);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ConsecrationConfig.CONFIG_SPEC);
    }

    private void setup(FMLCommonSetupEvent evt) {
        UndyingCapability.register();
        CriteriaTriggers.func_192118_a((ICriterionTrigger)SmiteTrigger.INSTANCE);
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185233_e)}), (Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151153_ao}), (ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)ConsecrationRegistry.HOLY_POTION));
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)ConsecrationRegistry.HOLY_POTION)}), (Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151137_ax}), (ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)ConsecrationRegistry.STRONG_HOLY_POTION));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        ConsecrationRenderer.register();
    }

    private void imcProcess(InterModProcessEvent evt) {
        ConsecrationSeed.registerImc(evt.getIMCStream());
    }

    private void config(ModConfig.ModConfigEvent evt) {
        if (evt.getConfig().getModId().equals(MODID)) {
            ConsecrationConfig.bake();
        }
    }

    @SubscribeEvent
    public void serverStart(FMLServerAboutToStartEvent evt) {
        ConsecrationApi.setHolyRegistry(new HolyRegistry());
        ConsecrationSeed.fillRegistry();
    }

    @SubscribeEvent
    public void serverStopped(FMLServerStoppedEvent evt) {
        ConsecrationApi.setHolyRegistry(null);
    }
}

