/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.consecration.api.ConsecrationApi;
import top.theillusivec4.consecration.api.IHolyRegistry;
import top.theillusivec4.consecration.common.ConsecrationConfig;
import top.theillusivec4.consecration.common.ConsecrationParser;

public class ConsecrationSeed {
    private static Map<EntityType<?>, ConsecrationApi.UndeadType> undeadMapImc = new HashMap();
    private static List<BiFunction<LivingEntity, DamageSource, Boolean>> holyAttacksImc = new ArrayList<BiFunction<LivingEntity, DamageSource, Boolean>>();
    private static List<BiFunction<LivingEntity, DamageSource, Integer>> holyProtectionImc = new ArrayList<BiFunction<LivingEntity, DamageSource, Integer>>();
    private static Set<EntityType<?>> holyEntitiesImc = new HashSet();
    private static Set<Effect> holyEffectsImc = new HashSet<Effect>();
    private static Set<Item> holyItemsImc = new HashSet<Item>();
    private static Set<Enchantment> holyEnchantmentsImc = new HashSet<Enchantment>();
    private static Set<String> holyDamageImc = new HashSet<String>();
    private static Set<String> holyMaterialsImc = new HashSet<String>();
    private static Map<EntityType<?>, ConsecrationApi.UndeadType> undeadMap = new HashMap();
    private static Set<EntityType<?>> holyEntities = new HashSet();
    private static Set<Effect> holyEffects = new HashSet<Effect>();
    private static Set<Item> holyItems = new HashSet<Item>();
    private static Set<Enchantment> holyEnchantments = new HashSet<Enchantment>();
    private static Set<String> holyDamage = new HashSet<String>();
    private static Set<String> holyMaterials = new HashSet<String>();

    public static void fillRegistry() {
        ConsecrationSeed.registerConfig();
        IHolyRegistry registry = ConsecrationApi.getHolyRegistry();
        registry.clear();
        undeadMapImc.forEach(registry::addUndead);
        holyAttacksImc.forEach(registry::addHolyAttack);
        holyProtectionImc.forEach(registry::addHolyProtection);
        holyEnchantmentsImc.forEach(registry::addHolyEnchantment);
        holyEntitiesImc.forEach(registry::addHolyEntity);
        holyEffectsImc.forEach(registry::addHolyEffect);
        holyItemsImc.forEach(registry::addHolyItem);
        holyDamageImc.forEach(registry::addHolyDamage);
        holyMaterialsImc.forEach(registry::addHolyMaterial);
        undeadMap.forEach(registry::addUndead);
        holyEnchantments.forEach(registry::addHolyEnchantment);
        holyEntities.forEach(registry::addHolyEntity);
        holyEffects.forEach(registry::addHolyEffect);
        holyItems.forEach(registry::addHolyItem);
        holyDamage.forEach(registry::addHolyDamage);
        holyMaterials.forEach(registry::addHolyMaterial);
    }

    public static void registerImc(Stream<InterModComms.IMCMessage> imcStream) {
        if (imcStream != null) {
            imcStream.forEach(imcMessage -> {
                Object message = imcMessage.getMessageSupplier().get();
                String method = imcMessage.getMethod();
                if (message instanceof String) {
                    String content = (String)message;
                    switch (method) {
                        case "undead": {
                            ConsecrationParser.getUndeadType(content).ifPresent(tuple -> undeadMapImc.putIfAbsent((EntityType<?>)tuple.func_76341_a(), (ConsecrationApi.UndeadType)((Object)((Object)((Object)tuple.func_76340_b())))));
                            break;
                        }
                        case "holy_entity": {
                            EntityType.func_220327_a((String)content).ifPresent(type -> holyEntitiesImc.add((EntityType<?>)type));
                            break;
                        }
                        case "holy_effect": {
                            Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(content));
                            if (effect == null) break;
                            holyEffectsImc.add(effect);
                            break;
                        }
                        case "holy_item": {
                            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(content));
                            if (item == null) break;
                            holyItemsImc.add(item);
                            break;
                        }
                        case "holy_enchantment": {
                            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(content));
                            if (enchantment == null) break;
                            holyEnchantmentsImc.add(enchantment);
                            break;
                        }
                        case "holy_material": {
                            holyMaterialsImc.add(content);
                            break;
                        }
                        case "holy_damage": {
                            holyDamageImc.add(content);
                        }
                    }
                } else if (message instanceof BiFunction) {
                    switch (method) {
                        case "holy_attack": {
                            holyAttacksImc.add((BiFunction)message);
                            break;
                        }
                        case "holy_protection": {
                            holyProtectionImc.add((BiFunction)message);
                        }
                    }
                }
            });
        }
    }

    public static void registerConfig() {
        undeadMap.clear();
        holyEntities.clear();
        holyEffects.clear();
        holyItems.clear();
        holyEnchantments.clear();
        holyDamage.clear();
        holyMaterials.clear();
        ConsecrationConfig.undeadList.forEach(undead -> ConsecrationParser.getUndeadType(undead).ifPresent(tuple -> undeadMap.putIfAbsent((EntityType<?>)tuple.func_76341_a(), (ConsecrationApi.UndeadType)((Object)((Object)((Object)tuple.func_76340_b()))))));
        ConsecrationConfig.holyEntities.forEach(entity -> EntityType.func_220327_a((String)entity).ifPresent(type -> holyEntities.add((EntityType<?>)type)));
        ConsecrationConfig.holyEffects.forEach(effect -> {
            Effect type = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(effect));
            if (type != null) {
                holyEffects.add(type);
            }
        });
        ConsecrationConfig.holyItems.forEach(item -> {
            Item type = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item));
            if (type != null) {
                holyItems.add(type);
            }
        });
        ConsecrationConfig.holyEnchantments.forEach(enchantment -> {
            Enchantment type = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantment));
            if (type != null) {
                holyEnchantments.add(type);
            }
        });
        holyDamage.addAll(ConsecrationConfig.holyDamage);
        holyMaterials.addAll(ConsecrationConfig.holyMaterials);
    }
}

