/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common.potion;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.Level;
import top.theillusivec4.consecration.Consecration;
import top.theillusivec4.consecration.api.ConsecrationApi;
import top.theillusivec4.consecration.common.capability.UndyingCapability;

public class HolyEffect
extends Effect {
    private static final Method START_CONVERTING = ObfuscationReflectionHelper.findMethod(ZombieVillagerEntity.class, (String)"func_191991_a", (Class[])new Class[]{UUID.class, Integer.TYPE});

    public HolyEffect() {
        super(EffectType.BENEFICIAL, 0xFFFFFF);
        this.setRegistryName("consecration:holy");
    }

    public void func_180793_a(@Nullable Entity source, @Nullable Entity indirectSource, @Nonnull LivingEntity livingEntity, int amplifier, double health) {
        if (livingEntity instanceof ZombieVillagerEntity) {
            this.convertZombieVillager((ZombieVillagerEntity)livingEntity, indirectSource, 1800 >> amplifier);
        } else {
            LazyOptional<UndyingCapability.IUndying> undyingOpt = UndyingCapability.getCapability(livingEntity);
            undyingOpt.ifPresent(undying -> {
                if (source == null) {
                    livingEntity.func_70097_a(ConsecrationApi.getHolyRegistry().causeHolyDamage(), (float)(8 << amplifier));
                } else {
                    livingEntity.func_70097_a(ConsecrationApi.getHolyRegistry().causeIndirectHolyDamage(source, indirectSource), (float)(8 << amplifier));
                }
            });
            if (!undyingOpt.isPresent()) {
                livingEntity.func_195064_c(new EffectInstance(Effects.field_76428_l, 600, amplifier));
                livingEntity.func_195064_c(new EffectInstance(Effects.field_76429_m, 600, amplifier));
            }
        }
    }

    public boolean func_76403_b() {
        return true;
    }

    private void convertZombieVillager(ZombieVillagerEntity zombieVillager, @Nullable Entity source, int conversionTime) {
        if (zombieVillager.func_82230_o()) {
            return;
        }
        UUID uuid = source instanceof PlayerEntity ? source.func_110124_au() : null;
        try {
            START_CONVERTING.invoke((Object)zombieVillager, uuid, zombieVillager.field_70170_p.field_73012_v.nextInt(200) + conversionTime);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Consecration.LOGGER.log(Level.ERROR, "Error in startConverting for entity " + zombieVillager);
        }
    }
}

