/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.network.NetworkHandler;
import net.blay09.mods.cookingforblockheads.network.message.MessageSyncedEffect;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CowJarHandler {
    private static final List<Class<? extends LivingEntity>> additionalCowClasses = Lists.newArrayList();

    public static void registerCowClass(Class<?> clazz) {
        additionalCowClasses.add(clazz);
    }

    @SubscribeEvent
    public void onEntityDamage(LivingAttackEvent event) {
        if (!((Boolean)CookingForBlockheadsConfig.COMMON.cowJarEnabled.get()).booleanValue()) {
            return;
        }
        if (event.getSource() == DamageSource.field_82728_o && this.isCow(event.getEntityLiving())) {
            BlockPos pos = event.getEntity().func_233580_cy_();
            BlockState blockBelow = event.getEntity().func_130014_f_().func_180495_p(pos);
            if (blockBelow.func_177230_c() == ModBlocks.milkJar) {
                event.getEntity().func_130014_f_().func_175656_a(pos, ModBlocks.cowJar.func_176223_P());
            }
            NetworkHandler.sendToAllTracking(new MessageSyncedEffect(pos, MessageSyncedEffect.Type.COW_IN_A_JAR), event.getEntity());
            event.getEntity().func_70106_y();
            event.setCanceled(true);
        }
    }

    public boolean isCow(LivingEntity entity) {
        if (entity instanceof CowEntity) {
            return true;
        }
        for (Class<? extends LivingEntity> clazz : additionalCowClasses) {
            if (!clazz.isAssignableFrom(entity.getClass())) continue;
            return true;
        }
        ResourceLocation registryName = entity.func_200600_R().getRegistryName();
        return registryName != null && registryName.func_110623_a().contains("cow");
    }
}

