/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat.jei;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.compat.jei.CowJarRecipe;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class CowJarRecipeCategory
implements IRecipeCategory<CowJarRecipe> {
    private static final ResourceLocation texture = new ResourceLocation("cookingforblockheads", "textures/gui/jei_cow_jar.png");
    public static final ResourceLocation UID = new ResourceLocation("cookingforblockheads", "cow_jar");
    private final IDrawableStatic background;
    private final IDrawable icon;
    private final String title;
    private final IDrawableStatic overlay;

    public CowJarRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(150, 110);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.cowJar));
        this.title = I18n.func_135052_a((String)"jei.cookingforblockheads:cow_jar", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(texture, 0, 0, 64, 80);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends CowJarRecipe> getRecipeClass() {
        return CowJarRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(CowJarRecipe cowJarRecipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, (List)ImmutableList.of((Object)new ItemStack((IItemProvider)Items.field_221844_ef), (Object)new ItemStack((IItemProvider)ModBlocks.milkJar)));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)ModBlocks.cowJar));
    }

    public void setRecipe(IRecipeLayout recipeLayout, CowJarRecipe recipeWrapper, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 64, 0);
        recipeLayout.getItemStacks().init(1, true, 64, 76);
        recipeLayout.getItemStacks().set(ingredients);
    }

    public void draw(CowJarRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.overlay.draw(matrixStack, 56, 20);
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
    }
}

