/*
 * Decompiled with CFR 0.152.
 */
package com.srgnis.creeperaiupdated.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public final class Config {
    public static final GeneralConfig COMMON;
    private static final ForgeConfigSpec COMMON_SPEC;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, COMMON_SPEC);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(GeneralConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (GeneralConfig)specPair.getLeft();
    }

    public static final class GeneralConfig {
        public final ForgeConfigSpec.DoubleValue maxLayer;
        public final ForgeConfigSpec.DoubleValue minLayer;
        public final ForgeConfigSpec.DoubleValue powered_prob;
        public final ForgeConfigSpec.DoubleValue follow_range;
        public final ForgeConfigSpec.BooleanValue can_break_walls;
        public final ForgeConfigSpec.BooleanValue can_leap;
        public final ForgeConfigSpec.BooleanValue fire_explosions;

        GeneralConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.powered_prob = builder.comment("Probability of creepers spawning powered.").defineInRange("powered_prob", 0.3, 0.0, 1.0);
            this.follow_range = builder.comment("Maximum distance a creeper can see and follow you. (32 = vanilla)").defineInRange("follow_range", 64.0, 0.0, 2048.0);
            this.can_break_walls = builder.comment("Creeper ability to breach trough walls or not").define("can_break_walls", true);
            this.can_leap = builder.comment("Creeper ability to leap at targets").define("can_leap", true);
            this.fire_explosions = builder.comment("Creeper explosions cause fire").define("fire_explosions", true);
            this.maxLayer = builder.comment("Maximum Y layer where creepers can spawn with the breaching ability.(Sea level = 62)").defineInRange("maxLayer", 255.0, 0.0, 255.0);
            this.minLayer = builder.comment("Minimum Y layer where creepers can spawn with the breaching ability.(Sea level = 62)").defineInRange("minLayer", 62.0, 0.0, 255.0);
            builder.pop();
        }
    }
}

