/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm;

import com.wjbaker.ccm.config.CrosshairConfig;
import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.keybind.Keybinds;
import com.wjbaker.ccm.util.Utils;
import java.io.BufferedReader;
import net.fabricmc.api.ModInitializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomCrosshairMod
implements ModInitializer {
    private static final Logger LOGGER = LogManager.getLogger(CustomCrosshairMod.class);
    public static final String MOD_NAME = "Custom Crosshair Mod";
    public static final String MOD_VERSION = "1.0.3-fabric";
    public static final String MC_VERSION = "1.16.2-fabric";
    public static final String CURSEFORGE = "https://www.curseforge.com/projects/242995/";
    public static final String MC_FORUMS = "https://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/2637819/";
    public static final CustomCrosshair CROSSHAIR = new CustomCrosshair();
    public static boolean isNewVersionAvailable = false;

    public void onInitialize() {
        new Keybinds().initKeybinds();
        if (!CrosshairConfig.readFromFile()) {
            CrosshairConfig.writeToFile();
        }
        this.checkVersion();
    }

    public static void log(String message, Object ... values) {
        LOGGER.info(message, values);
    }

    private void checkVersion() {
        try (BufferedReader content = Utils.httpGet("http://pastebin.com/raw/B2sL8QCh");){
            String currentLine;
            while ((currentLine = content.readLine()) != null) {
                String[] lineSplit = currentLine.split(" ");
                if (lineSplit.length <= 1 || !lineSplit[0].equals(MC_VERSION) || lineSplit[1].equals(MOD_VERSION)) continue;
                CustomCrosshairMod.log("[Version Checker] New version available.", new Object[0]);
                isNewVersionAvailable = true;
                break;
            }
        }
        catch (Exception e) {
            CustomCrosshairMod.log("[Version Checker] An error occurred.", new Object[0]);
            e.printStackTrace();
        }
    }
}

