/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.style;

import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.render.ComputedProperties;
import com.wjbaker.ccm.crosshair.style.CrosshairStyle;
import com.wjbaker.ccm.object.RGBA;
import com.wjbaker.ccm.render.RenderManager;

public class SquareStyle
extends CrosshairStyle {
    public SquareStyle() {
        super("Square");
    }

    @Override
    public void draw(CustomCrosshair crosshair, ComputedProperties computedProperties, int x, int y) {
        boolean outlineEnabled = crosshair.getPropertyValue("outline_enabled", Boolean.class);
        float thickness = crosshair.getPropertyValue("crosshair_thickness", Integer.class).intValue();
        int width = crosshair.getPropertyValue("crosshair_width", Integer.class);
        int height = crosshair.getPropertyValue("crosshair_height", Integer.class);
        if (outlineEnabled) {
            RGBA outlineColour = crosshair.getPropertyValue("outline_colour", RGBA.class);
            this.drawOutline(x, y, computedProperties.getGap(), width, height, thickness, outlineColour);
        }
        this.drawBars(x, y, computedProperties.getGap(), width, height, thickness, computedProperties.getColour());
    }

    private void drawBars(int x, int y, int gap, int width, int height, float thickness, RGBA colour) {
        RenderManager.drawFilledRectangle((float)(x - width) - thickness - (float)gap, (float)(y - height) - thickness - (float)gap, (float)(x + width) + thickness + (float)gap, y - height - gap, colour, true);
        RenderManager.drawFilledRectangle((float)(x - width) - thickness - (float)gap, y + height + gap, (float)(x + width) + thickness + (float)gap, (float)(y + height) + thickness + (float)gap, colour, true);
        RenderManager.drawFilledRectangle((float)(x - width) - thickness - (float)gap, y - gap - height, x - width - gap, y + gap + height, colour, true);
        RenderManager.drawFilledRectangle(x + width + gap, y - gap - height, (float)(x + width) + thickness + (float)gap, y + gap + height, colour, true);
    }

    private void drawOutline(int x, int y, int gap, int width, int height, float thickness, RGBA colour) {
        RenderManager.drawRectangle((float)(x - width - gap) + 0.5f, (float)(y - height - gap) + 0.5f, (float)(x + width + gap) - 0.5f, (float)(y + height + gap) - 0.5f, 2.0f, colour, true);
        RenderManager.drawRectangle((float)(x - width) - thickness - (float)gap - 0.5f, (float)(y - height) - thickness - (float)gap - 0.5f, (float)(x + width) + thickness + (float)gap + 0.5f, (float)(y + height) + thickness + (float)gap + 0.5f, 2.0f, colour, true);
    }
}

