/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.gui.screens;

import com.wjbaker.ccm.CustomCrosshairMod;
import com.wjbaker.ccm.config.CrosshairConfig;
import com.wjbaker.ccm.gui.GuiTheme;
import com.wjbaker.ccm.gui.components.Button;
import com.wjbaker.ccm.gui.components.Component;
import com.wjbaker.ccm.gui.screens.ScreenWrapper;
import com.wjbaker.ccm.object.RGBA;
import com.wjbaker.ccm.render.RenderManager;
import com.wjbaker.ccm.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_437;

public abstract class Screen
extends ScreenWrapper {
    protected List<Component> components = new ArrayList<Component>();
    protected boolean isHeaderVisible = true;
    private int headerHeight = 35;
    private int dragStartX;
    private int dragStartY;
    private Screen parentScreen;
    private Button newVersionButton = new Button(this, "New Version Available!", this.field_22789, 8, 120, 20){

        @Override
        public void onMouseUp(int mouseX, int mouseY) {
            System.out.println(Utils.openInBrowser("https://www.curseforge.com/projects/242995/"));
        }
    };

    public Screen() {
        this.newVersionButton.setBackgroundColour(new RGBA(255, 180, 0, 255));
        this.newVersionButton.hoverBackgroundColour = new RGBA(204, 143, 0, 255);
        this.newVersionButton.setTextColour(-14540254);
        this.newVersionButton.hoverTextColour = -14540254;
        if (CustomCrosshairMod.isNewVersionAvailable) {
            this.components.add(this.newVersionButton);
        }
    }

    @Override
    public void updateScreen() {
        this.newVersionButton.setPosition(this.field_22789 - this.newVersionButton.getWidth() - 8, 7);
    }

    @Override
    public void drawScreen(int mouseX, int mouseY) {
        this.drawBackground();
        this.components.stream().filter(c -> c != this.newVersionButton).forEach(Component::drawComponent);
        if (this.isHeaderVisible) {
            this.drawScreenHeader();
        }
        if (this.components.contains(this.newVersionButton)) {
            this.newVersionButton.drawComponent();
        }
    }

    private void drawScreenHeader() {
        RenderManager.drawFilledRectangle(0.0f, 0.0f, this.field_22789, this.headerHeight - 1, GuiTheme.PRIMARY, true);
        RenderManager.drawLine(0.0f, this.headerHeight - 1, this.field_22789, this.headerHeight - 1, 1.0f, GuiTheme.DARK_GREY, true);
        String title = "Custom Crosshair Mod v1.0.3-fabric";
        RenderManager.drawStringWidthShadow(title, 10, 13, -1);
    }

    private void drawBackground() {
        RenderManager.drawFilledRectangle(0.0f, 0.0f, this.field_22789, this.field_22790, GuiTheme.BLACK.setOpacity(140), true);
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY, int button) {
        this.components.forEach(component -> {
            if (!component.isWithinBounds(mouseX, mouseY)) {
                return;
            }
            component.onMouseUp(mouseX, mouseY);
        });
    }

    @Override
    public void onMouseDown(int mouseX, int mouseY, int button) {
        this.dragStartX = mouseX;
        this.dragStartY = mouseY;
        this.components.forEach(component -> {
            if (!component.isWithinBounds(mouseX, mouseY)) {
                return;
            }
            component.onMouseDown(mouseX, mouseY);
        });
    }

    @Override
    public void onMouseMove(int mouseX, int mouseY) {
        this.components.forEach(component -> {
            component.setMouseOver(false);
            if (component.isWithinBounds(mouseX, mouseY)) {
                component.setMouseOver(true);
                component.onMouseMove(mouseX, mouseY);
            }
        });
    }

    @Override
    public void onMouseDrag(int startX, int startY, int mouseX, int mouseY, long dragTime) {
        this.components.forEach(component -> component.onMouseDrag(startX, startY, mouseX, mouseY, dragTime));
    }

    @Override
    public void onMouseScrollUp() {
    }

    @Override
    public void onMouseScrollDown() {
    }

    @Override
    public void onKeyUp(int keyCode, int modifiers) {
    }

    @Override
    public void onKeyDown(int keyCode, int modifiers) {
        if (keyCode == 256 && this.parentScreen != null) {
            class_310.method_1551().method_1507((class_437)this.parentScreen);
        }
    }

    public void method_25419() {
        CrosshairConfig.writeToFile();
        super.method_25419();
    }

    public int getHeaderHeight() {
        return this.headerHeight;
    }

    public void setParentScreen(Screen parentScreen) {
        this.parentScreen = parentScreen;
    }

    public Screen getParentScreen() {
        return this.parentScreen;
    }
}

