/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.style;

import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.render.ComputedProperties;
import com.wjbaker.ccm.crosshair.style.CrosshairStyle;
import com.wjbaker.ccm.object.RGBA;
import com.wjbaker.ccm.render.RenderManager;
import net.minecraft.class_310;

public class CrossStyle
extends CrosshairStyle {
    public CrossStyle() {
        super("Cross");
    }

    @Override
    public void draw(CustomCrosshair crosshair, ComputedProperties computedProperties, int x, int y) {
        if (!computedProperties.doRender()) {
            return;
        }
        boolean outlineEnabled = crosshair.getPropertyValue("outline_enabled", Boolean.class);
        float thickness = (float)crosshair.getPropertyValue("crosshair_thickness", Integer.class).intValue() / 2.0f;
        int width = crosshair.getPropertyValue("crosshair_width", Integer.class);
        int height = crosshair.getPropertyValue("crosshair_height", Integer.class);
        int gap = computedProperties.getGap();
        RGBA colour = computedProperties.getColour();
        if (outlineEnabled) {
            this.drawOutline(crosshair, x, y, gap, width, height, thickness);
        }
        this.drawBars(x, y, gap, width, height, thickness, colour);
    }

    private void drawBars(int x, int y, int renderGap, int width, int height, float thickness, RGBA renderColour) {
        RenderManager.drawFilledRectangle((float)x - thickness, y - renderGap - height, (float)x + thickness, y - renderGap, renderColour, true);
        RenderManager.drawFilledRectangle((float)x - thickness, y + renderGap, (float)x + thickness, y + renderGap + height, renderColour, true);
        RenderManager.drawFilledRectangle(x - renderGap - width, (float)y - thickness, x - renderGap, (float)y + thickness, renderColour, true);
        RenderManager.drawFilledRectangle(x + renderGap, (float)y - thickness, x + renderGap + width, (float)y + thickness, renderColour, true);
    }

    private void drawOutline(CustomCrosshair crosshair, int x, int y, int renderGap, int width, int height, float thickness) {
        RGBA outlineColour = crosshair.getPropertyValue("outline_colour", RGBA.class);
        int guiScale = class_310.method_1551().field_1690.field_1868;
        float offset = 0.5f;
        if (guiScale == 4 || guiScale == 3) {
            offset = 0.5f;
        }
        float outlineThickness = 2.0f;
        RenderManager.drawRectangle((float)x - thickness - offset, (float)(y - renderGap - height) - offset, (float)x + thickness + offset, (float)(y - renderGap) + offset, outlineThickness, outlineColour, true);
        RenderManager.drawRectangle((float)x - thickness - offset, (float)(y + renderGap) - offset, (float)x + thickness + offset, (float)(y + renderGap + height) + offset, outlineThickness, outlineColour, true);
        RenderManager.drawRectangle((float)(x - renderGap - width) - offset, (float)y - thickness - offset, (float)(x - renderGap) + offset, (float)y + thickness + offset, outlineThickness, outlineColour, true);
        RenderManager.drawRectangle((float)(x + renderGap) - offset, (float)y - thickness - offset, (float)(x + renderGap + width) + offset, (float)y + thickness + offset, outlineThickness, outlineColour, true);
    }
}

