/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.property;

import com.wjbaker.ccm.object.RGBA;
import java.util.UnknownFormatConversionException;

public abstract class PropertyConverter {
    private PropertyConverter() {
    }

    public static Object convertToType(String value, Class clazz) {
        try {
            return PropertyConverter.doConversion(value, clazz);
        }
        catch (Exception e) {
            throw new UnknownFormatConversionException("Unable to convert property value.");
        }
    }

    private static Object doConversion(String value, Class clazz) {
        if (String.class.getName().equals(clazz.getName())) {
            return value;
        }
        if (Integer.class.getName().equals(clazz.getName())) {
            return Integer.valueOf(value);
        }
        if (Boolean.class.getName().equals(clazz.getName())) {
            return Boolean.valueOf(value);
        }
        if (Character.class.getName().equals(clazz.getName())) {
            return Character.valueOf(value.charAt(0));
        }
        if (Long.class.getName().equals(clazz.getName())) {
            return Long.valueOf(value);
        }
        if (RGBA.class.getName().equals(clazz.getName())) {
            String[] split = value.split("/");
            int red = Integer.valueOf(split[0]);
            int green = Integer.valueOf(split[1]);
            int blue = Integer.valueOf(split[2]);
            int opacity = Integer.valueOf(split[3]);
            return new RGBA(red, green, blue, opacity);
        }
        return null;
    }
}

