/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.gui.components;

import com.wjbaker.ccm.gui.GuiTheme;
import com.wjbaker.ccm.gui.components.Component;
import com.wjbaker.ccm.gui.components.Panel;
import com.wjbaker.ccm.gui.screens.Screen;
import com.wjbaker.ccm.object.RGBA;
import com.wjbaker.ccm.render.RenderManager;

public class ScrollPanel
extends Panel {
    private boolean isMouseOverThumb = false;
    private boolean isDragging = false;
    private int thumbWidth = 9;
    private int thumbHeight = 30;
    private int grabOffset = 0;
    private int currentScrollValue = 0;
    private RGBA thumbBackgroundColour = GuiTheme.PRIMARY;
    private int contentHeight = 0;

    public ScrollPanel(Screen parentScreen, int x, int y, int width, int height) {
        super(parentScreen, x, y, width, height);
    }

    @Override
    public void drawComponent() {
        RenderManager.drawBorderedRectangle(this.x + this.width - this.thumbWidth, this.y, this.x + this.width, this.y + this.height, 1.0f, GuiTheme.DARK_GREY, GuiTheme.PRIMARY, true);
        RenderManager.drawBorderedRectangle(this.x + this.width - this.thumbWidth, this.y + this.currentScrollValue, this.x + this.width, this.y + this.currentScrollValue + this.thumbHeight, 1.0f, GuiTheme.DARK_GREY, this.thumbBackgroundColour, true);
        this.components.forEach(Component::drawComponent);
    }

    @Override
    public void onMouseDrag(int startX, int startY, int mouseX, int mouseY, long dragTime) {
        if (this.isDragging) {
            int newScrollValue = mouseY - this.y - this.grabOffset;
            this.setScrollValue(newScrollValue);
        }
        super.onMouseDrag(startX, startY, mouseX, mouseY, dragTime);
    }

    @Override
    public void onMouseDown(int mouseX, int mouseY) {
        if (this.isOverThumb(mouseX, mouseY)) {
            this.isDragging = true;
            this.grabOffset = mouseY - this.currentScrollValue - this.thumbHeight - 5;
        }
        super.onMouseDown(mouseX, mouseY);
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY) {
        this.isDragging = false;
        super.onMouseUp(mouseX, mouseY);
    }

    @Override
    public void onMouseMove(int mouseX, int mouseY) {
        boolean isMouseOverThumb = this.isOverThumb(mouseX, mouseY);
        if (this.isMouseOverThumb != isMouseOverThumb) {
            this.thumbBackgroundColour = isMouseOverThumb ? GuiTheme.SECONDARY : GuiTheme.PRIMARY;
            this.isMouseOverThumb = isMouseOverThumb;
        }
        super.onMouseMove(mouseX, mouseY);
    }

    private void setComponentPositions() {
        int outsideContentHeight = this.contentHeight + this.yOffset - this.height;
        float scrollRatio = (float)(-this.currentScrollValue) / (float)(this.height - this.thumbHeight);
        int height = (int)((float)outsideContentHeight * scrollRatio);
        for (Component component : this.components) {
            component.setPosition(this.x + this.xOffset, this.y + this.yOffset + height);
            height += component.height + this.componentSpacing;
        }
    }

    private boolean isOverThumb(int mouseX, int mouseY) {
        return mouseX > this.x + this.width - this.thumbWidth && mouseX < this.x + this.width && mouseY > this.y + this.currentScrollValue && mouseY < this.y + this.currentScrollValue + this.thumbHeight;
    }

    public void incrementScroll(int increment) {
        int newScrollValue = this.currentScrollValue + increment;
        this.setScrollValue(newScrollValue);
    }

    private void setScrollValue(int scrollValue) {
        int newScrollValue = scrollValue;
        int maxHeight = this.height - this.thumbHeight;
        if (newScrollValue < 0) {
            newScrollValue = 0;
        }
        if (newScrollValue > maxHeight) {
            newScrollValue = maxHeight;
        }
        this.currentScrollValue = newScrollValue;
        this.setComponentPositions();
    }

    @Override
    public void addComponent(Component component) {
        this.contentHeight += component.height + this.componentSpacing;
        super.addComponent(component);
    }

    @Override
    public void removeComponent(Component component) {
        this.contentHeight -= component.height + this.componentSpacing;
        super.removeComponent(component);
    }

    @Override
    public void packComponent() {
        super.packComponent();
        this.setComponentPositions();
    }
}

