/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.gui.components;

import com.wjbaker.ccm.CustomCrosshairMod;
import com.wjbaker.ccm.gui.GuiTheme;
import com.wjbaker.ccm.gui.components.Component;
import com.wjbaker.ccm.gui.screens.Screen;
import com.wjbaker.ccm.object.RGBA;
import com.wjbaker.ccm.render.RenderManager;

public class CheckBox
extends Component {
    private RGBA backgroundColour = GuiTheme.PRIMARY;
    private boolean isChecked = false;

    public CheckBox(Screen parentScreen, String label, int x, int y) {
        super(parentScreen, label, x, y, 11, 11);
    }

    @Override
    public void drawComponent() {
        RenderManager.drawBorderedRectangle(this.x, this.y, this.x + this.width, this.y + this.height, 1.0f, GuiTheme.DARK_GREY, this.currentBackgroundColour, true);
        if (this.isChecked) {
            RenderManager.drawBorderedRectangle(this.x + 2, this.y + 2, this.x + this.width - 2, this.y + this.height - 2, 1.0f, GuiTheme.SUCCESS, GuiTheme.SUCCESS, true);
        }
        RenderManager.drawString(this.label, this.x + this.width + 4, this.y + this.height / 2 - 3, -1);
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY) {
        this.toggleChecked();
    }

    public void toggleChecked() {
        this.setChecked(!this.isChecked);
    }

    public void setChecked(boolean isChecked) {
        this.isChecked = isChecked;
        if (this.boundProperty != null) {
            CustomCrosshairMod.CROSSHAIR.setPropertyValue(this.boundProperty, this.isChecked);
        }
    }

    @Override
    public void bindProperty(String property) {
        super.bindProperty(property);
        this.setChecked(CustomCrosshairMod.CROSSHAIR.getPropertyValue(this.boundProperty, Boolean.class));
    }

    public boolean isChecked() {
        return this.isChecked;
    }
}

