/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.customsignposts.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.pavocado.customsignposts.init.SignpostsBlocks;
import net.pavocado.customsignposts.init.SignpostsItems;
import net.pavocado.customsignposts.init.SignpostsMod;
import net.pavocado.customsignposts.tileentity.TileEntitySignpost;

public class BlockSignpost
extends BlockContainer {
    public static final ResourceLocation ACACIA_SIGN = new ResourceLocation("customsignposts:textures/signs/signpost_acacia.png");
    public static final ResourceLocation DARK_OAK_SIGN = new ResourceLocation("customsignposts:textures/signs/signpost_dark_oak.png");
    public static final ResourceLocation JUNGLE_SIGN = new ResourceLocation("customsignposts:textures/signs/signpost_jungle.png");
    public static final ResourceLocation BIRCH_SIGN = new ResourceLocation("customsignposts:textures/signs/signpost_birch.png");
    public static final ResourceLocation OAK_SIGN = new ResourceLocation("customsignposts:textures/signs/signpost_oak.png");
    public static final ResourceLocation SPRUCE_SIGN = new ResourceLocation("customsignposts:textures/signs/signpost_spruce.png");
    public static final ResourceLocation COBBLESTONE_SIGN = new ResourceLocation("customsignposts:textures/signs/signpost_cobblestone.png");
    public static final ResourceLocation NETHER_BRICK_SIGN = new ResourceLocation("customsignposts:textures/signs/signpost_nether_brick.png");
    public static final ResourceLocation SANDSTONE_SIGN = new ResourceLocation("customsignposts:textures/signs/signpost_sandstone.png");
    public static final ResourceLocation RED_SANDSTONE_SIGN = new ResourceLocation("customsignposts:textures/signs/signpost_red_sandstone.png");
    public static final PropertyEnum<BlockDoor.EnumDoorHalf> HALF = PropertyEnum.func_177709_a((String)"half", BlockDoor.EnumDoorHalf.class);
    public static final AxisAlignedBB SIGN_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    private final Block modelBlock;
    private final IBlockState modelState;
    private final ResourceLocation modelTexture;

    public BlockSignpost(IBlockState modelStateIn, ResourceLocation textureIn, SoundType soundType) {
        super(modelStateIn.func_185904_a());
        this.func_149672_a(soundType);
        this.modelBlock = modelStateIn.func_177230_c();
        this.modelState = modelStateIn;
        this.modelTexture = textureIn;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(HALF, (Comparable)BlockDoor.EnumDoorHalf.LOWER));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        if (state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER) {
            return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
        }
        return EnumBlockRenderType.MODEL;
    }

    public ResourceLocation getSignTexture() {
        return this.modelTexture;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SIGN_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return SIGN_AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_181623_g() {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            BlockPos blockpos;
            BlockPos blockPos = blockpos = state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER ? pos : pos.func_177984_a();
            if (worldIn.func_175625_s(blockpos) instanceof TileEntitySignpost) {
                playerIn.openGui((Object)SignpostsMod.modInstance, 1, worldIn, blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
            }
        }
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER ? Items.field_190931_a : this.getItem();
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.getItem());
    }

    private Item getItem() {
        if (this == SignpostsBlocks.acacia_signpost) {
            return SignpostsItems.acacia_signpost;
        }
        if (this == SignpostsBlocks.jungle_signpost) {
            return SignpostsItems.jungle_signpost;
        }
        if (this == SignpostsBlocks.dark_oak_signpost) {
            return SignpostsItems.dark_oak_signpost;
        }
        if (this == SignpostsBlocks.birch_signpost) {
            return SignpostsItems.birch_signpost;
        }
        if (this == SignpostsBlocks.spruce_signpost) {
            return SignpostsItems.spruce_signpost;
        }
        if (this == SignpostsBlocks.cobblestone_signpost) {
            return SignpostsItems.cobblestone_signpost;
        }
        if (this == SignpostsBlocks.sandstone_signpost) {
            return SignpostsItems.sandstone_signpost;
        }
        if (this == SignpostsBlocks.red_sandstone_signpost) {
            return SignpostsItems.red_sandstone_signpost;
        }
        return this == SignpostsBlocks.nether_brick_signpost ? SignpostsItems.nether_brick_signpost : SignpostsItems.oak_signpost;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && worldIn.func_175623_d(pos.func_177984_a());
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos blockpos = pos.func_177977_b();
        BlockPos blockpos1 = pos.func_177984_a();
        if (player.field_71075_bZ.field_75098_d && state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER && worldIn.func_180495_p(blockpos).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos);
        }
        if (state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.LOWER && worldIn.func_180495_p(blockpos1).func_177230_c() == this) {
            if (player.field_71075_bZ.field_75098_d) {
                worldIn.func_175698_g(pos);
            }
            worldIn.func_175698_g(blockpos1);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER) {
            BlockPos blockpos = pos.func_177977_b();
            IBlockState iblockstate = worldIn.func_180495_p(blockpos);
            if (iblockstate.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            } else if (blockIn != this) {
                iblockstate.func_189546_a(worldIn, blockpos, blockIn, fromPos);
            }
        } else {
            BlockPos blockpos1 = pos.func_177984_a();
            IBlockState iblockstate1 = worldIn.func_180495_p(blockpos1);
            if (iblockstate1.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
                if (!worldIn.field_72995_K) {
                    this.func_176226_b(worldIn, pos, state, 0);
                }
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        return meta == 0 ? this.func_176223_P().func_177226_a(HALF, (Comparable)BlockDoor.EnumDoorHalf.LOWER) : this.func_176223_P().func_177226_a(HALF, (Comparable)BlockDoor.EnumDoorHalf.UPPER);
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (state.func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER) {
            i = 1;
        }
        return i;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN ? BlockFaceShape.UNDEFINED : BlockFaceShape.CENTER;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.modelBlock.func_180659_g(this.modelState, worldIn, pos);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (this.func_176203_a(meta).func_177229_b(HALF) == BlockDoor.EnumDoorHalf.UPPER) {
            return new TileEntitySignpost();
        }
        return null;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF});
    }
}

