/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.customsignposts.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.pavocado.customsignposts.container.ContainerSignpost;
import net.pavocado.customsignposts.network.MessageUpdateSignpost;
import net.pavocado.customsignposts.network.NetworkHandler;
import net.pavocado.customsignposts.signs.CustomAngleSign;
import net.pavocado.customsignposts.signs.CustomCoordinateSign;
import net.pavocado.customsignposts.signs.ISignType;
import net.pavocado.customsignposts.tileentity.TileEntitySignpost;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiSignpost
extends GuiContainer {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("customsignposts:textures/gui/signpost.png");
    private List<SignInput> signInputList;
    private TileEntitySignpost signpostEntity;

    public GuiSignpost(TileEntitySignpost tileEntity, World world) {
        super((Container)new ContainerSignpost(world, BlockPos.field_177992_a));
        this.field_146999_f = 256;
        this.field_147000_g = 204;
        this.signpostEntity = tileEntity;
        this.field_146291_p = true;
    }

    public void func_73876_c() {
        for (SignInput signInput : this.signInputList) {
            for (GuiTextField inputField : signInput.textFieldArray) {
                inputField.func_146178_a();
            }
        }
        super.func_73876_c();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.add(new FinaliseButton(0, i + 198, j + 178, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.field_146292_n.add(new FinaliseButton(1, i + 142, j + 178, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.signInputList = new ArrayList<SignInput>();
        block4: for (int x = 0; x < 7; ++x) {
            SignInput signInput = new SignInput(x + 1, i + 7, j + 16 + x * 23, this.field_146289_q);
            this.signInputList.add(signInput);
            this.field_146292_n.add(signInput.signButton);
            ISignType iSignType = this.signpostEntity.signs[x];
            if (iSignType != null) {
                signInput.currentSignType = iSignType.getSignType();
                signInput.nameField.func_146180_a(String.valueOf(iSignType.getText().func_150260_c()));
            } else {
                signInput.currentSignType = TileEntitySignpost.SignType.NONE;
            }
            signInput.updateSignType();
            switch (signInput.currentSignType) {
                case COORDINATE: {
                    signInput.coordX.func_146180_a(String.valueOf(iSignType.getTarget().func_177958_n()));
                    signInput.coordZ.func_146180_a(String.valueOf(iSignType.getTarget().func_177952_p()));
                    continue block4;
                }
                case ANGLE: {
                    signInput.angleField.func_146180_a(String.valueOf(iSignType.getAngle()));
                }
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(BACKGROUND_TEXTURE);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        for (SignInput signInput : this.signInputList) {
            signInput.drawBackground(this, i, j);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = I18n.func_135052_a((String)"container.customsignposts.signpost", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
        for (SignInput signInput : this.signInputList) {
            signInput.drawForeground((this.field_146294_l - this.field_146999_f) / 2, (this.field_146295_m - this.field_147000_g) / 2);
        }
    }

    private void saveAndClose() {
        ISignType[] signTypes = new ISignType[]{null, null, null, null, null, null, null};
        for (int i = 0; i < 7; ++i) {
            int targetZ;
            int targetX;
            SignInput signInput = this.signInputList.get(i);
            if (signInput == null) continue;
            if (signInput.currentSignType == TileEntitySignpost.SignType.NONE) {
                signTypes[i] = null;
                continue;
            }
            if (signInput.currentSignType == TileEntitySignpost.SignType.ANGLE) {
                int angle;
                try {
                    angle = Integer.parseInt(signInput.angleField.func_146179_b());
                }
                catch (NumberFormatException ex) {
                    angle = 0;
                }
                signTypes[i] = new CustomAngleSign((ITextComponent)new TextComponentString(signInput.nameField.func_146179_b()), angle);
                continue;
            }
            if (signInput.currentSignType != TileEntitySignpost.SignType.COORDINATE) continue;
            try {
                targetX = Integer.parseInt(signInput.coordX.func_146179_b());
                targetZ = Integer.parseInt(signInput.coordZ.func_146179_b());
            }
            catch (NumberFormatException ex) {
                targetX = 0;
                targetZ = 0;
            }
            signTypes[i] = new CustomCoordinateSign((ITextComponent)new TextComponentString(signInput.nameField.func_146179_b()), new BlockPos(targetX, 0, targetZ), this.signpostEntity.func_174877_v());
        }
        NetworkHandler.sendToServer(new MessageUpdateSignpost(this.signpostEntity, signTypes));
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        boolean isTyping = false;
        for (SignInput signInput : this.signInputList) {
            for (GuiTextField inputField : signInput.textFieldArray) {
                if (!inputField.func_146201_a(typedChar, keyCode)) continue;
                isTyping = true;
                break;
            }
            if (!isTyping) continue;
            break;
        }
        if (!isTyping) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (SignInput signInput : this.signInputList) {
            for (GuiTextField inputField : signInput.textFieldArray) {
                inputField.func_146192_a(mouseX, mouseY, mouseButton);
            }
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                this.field_146297_k.func_147108_a(null);
                this.saveAndClose();
            } else if (button.field_146127_k == 1) {
                this.field_146297_k.func_147108_a(null);
            } else if (button instanceof SignButton) {
                ((SignButton)button).processUpdate();
            }
        }
    }

    static class SignInput {
        GuiTextField nameField;
        GuiTextField coordX;
        GuiTextField coordZ;
        GuiTextField angleField;
        GuiTextField[] textFieldArray;
        SignButton signButton;
        FontRenderer fontRenderer;
        TileEntitySignpost.SignType currentSignType = TileEntitySignpost.SignType.NONE;
        int posX;
        int posY;

        public SignInput(int inputId, int x, int y, FontRenderer fontRenderer) {
            this.fontRenderer = fontRenderer;
            this.posX = x;
            this.posY = y;
            this.nameField = new GuiTextField(inputId * 5, this.fontRenderer, x + 51, y + 5, 80, this.fontRenderer.field_78288_b);
            this.coordX = new GuiTextField(inputId * 5 + 1, this.fontRenderer, x + 162, y + 5, 26, this.fontRenderer.field_78288_b);
            this.coordZ = new GuiTextField(inputId * 5 + 2, this.fontRenderer, x + 210, y + 5, 26, this.fontRenderer.field_78288_b);
            this.angleField = new GuiTextField(inputId * 5 + 3, this.fontRenderer, x + 184, y + 5, 26, this.fontRenderer.field_78288_b);
            this.textFieldArray = new GuiTextField[]{this.nameField, this.coordX, this.coordZ, this.angleField};
            this.signButton = new SignButton(inputId * 5 + 4, x, y, this);
            this.updateSignType();
            this.nameField.func_146203_f(16);
            this.coordX.func_146203_f(9);
            this.coordZ.func_146203_f(9);
            this.angleField.func_146203_f(3);
            for (GuiTextField textField : this.textFieldArray) {
                textField.func_146185_a(false);
                textField.func_146189_e(true);
                textField.func_146184_c(true);
                textField.func_146193_g(0xFFFFFF);
            }
        }

        void drawBackground(GuiSignpost gui, int i, int j) {
            switch (this.currentSignType) {
                case ANGLE: {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    gui.field_146297_k.field_71446_o.func_110577_a(BACKGROUND_TEXTURE);
                    gui.func_73729_b(i + 157, this.posY + 3, 0, 230, 89, 13);
                    this.nameField.func_146194_f();
                    this.angleField.func_146194_f();
                    break;
                }
                case COORDINATE: {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    gui.field_146297_k.field_71446_o.func_110577_a(BACKGROUND_TEXTURE);
                    gui.func_73729_b(i + 157, this.posY + 3, 0, 217, 89, 13);
                    this.nameField.func_146194_f();
                    this.coordX.func_146194_f();
                    this.coordZ.func_146194_f();
                    break;
                }
                case NONE: {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    gui.field_146297_k.field_71446_o.func_110577_a(BACKGROUND_TEXTURE);
                    gui.func_73729_b(i + 56, this.posY + 3, 0, 204, 90, 13);
                }
            }
        }

        void drawForeground(int i, int j) {
            switch (this.currentSignType) {
                case ANGLE: {
                    String angleString = I18n.func_135052_a((String)"customsignposts.bearing", (Object[])new Object[0]);
                    this.fontRenderer.func_78276_b(angleString, 186 - this.fontRenderer.func_78256_a(angleString), this.posY - j + 6, 0x404040);
                    break;
                }
                case COORDINATE: {
                    String xString = "X:";
                    this.fontRenderer.func_78276_b(xString, 164 - this.fontRenderer.func_78256_a(xString), this.posY - j + 6, 0x404040);
                    String zString = "Z:";
                    this.fontRenderer.func_78276_b(zString, 212 - this.fontRenderer.func_78256_a(zString), this.posY - j + 6, 0x404040);
                    break;
                }
            }
        }

        void updateSignType() {
            for (GuiTextField textField : this.textFieldArray) {
                textField.func_146184_c(false);
            }
            switch (this.currentSignType) {
                case ANGLE: {
                    this.signButton.field_146126_j = I18n.func_135052_a((String)"customsignposts.angle", (Object[])new Object[0]);
                    this.nameField.func_146184_c(true);
                    this.angleField.func_146184_c(true);
                    this.angleField.func_146180_a("0");
                    break;
                }
                case COORDINATE: {
                    this.signButton.field_146126_j = I18n.func_135052_a((String)"customsignposts.coord", (Object[])new Object[0]);
                    this.nameField.func_146184_c(true);
                    this.coordX.func_146184_c(true);
                    this.coordZ.func_146184_c(true);
                    this.coordX.func_146180_a("0");
                    this.coordZ.func_146180_a("0");
                    break;
                }
                case NONE: {
                    this.signButton.field_146126_j = I18n.func_135052_a((String)"gui.none", (Object[])new Object[0]);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class FinaliseButton
    extends GuiButton {
        public FinaliseButton(int id, int xposition, int yposition, String text) {
            super(id, xposition, yposition, 50, 20, text);
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class SignButton
    extends GuiButton {
        SignInput signInput;

        public SignButton(int id, int xPosition, int yPosition, SignInput signInput) {
            super(id, xPosition, yPosition, 44, 20, "");
            this.signInput = signInput;
        }

        void processUpdate() {
            this.signInput.currentSignType = this.signInput.currentSignType.next();
            this.signInput.updateSignType();
        }
    }
}

