/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.customsignposts.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.pavocado.customsignposts.network.MessageBase;
import net.pavocado.customsignposts.signs.CustomAngleSign;
import net.pavocado.customsignposts.signs.CustomCoordinateSign;
import net.pavocado.customsignposts.signs.ISignType;
import net.pavocado.customsignposts.tileentity.TileEntitySignpost;

public class MessageUpdateSignpost
extends MessageBase<MessageUpdateSignpost> {
    private int posX;
    private int posY;
    private int posZ;
    private ISignType[] signTypes;

    public MessageUpdateSignpost() {
    }

    public MessageUpdateSignpost(TileEntitySignpost tileEntitySignpost, ISignType[] signTypesIn) {
        BlockPos pos = tileEntitySignpost.func_174877_v();
        this.posX = pos.func_177958_n();
        this.posY = pos.func_177956_o();
        this.posZ = pos.func_177952_p();
        this.signTypes = signTypesIn;
    }

    public void fromBytes(ByteBuf buf) {
        this.posX = buf.readInt();
        this.posY = buf.readInt();
        this.posZ = buf.readInt();
        this.signTypes = new ISignType[7];
        for (int i = 0; i < 7; ++i) {
            String signName;
            int currentSign = buf.readInt();
            if (currentSign == 0) {
                this.signTypes[i] = null;
                continue;
            }
            if (currentSign == 1) {
                signName = ByteBufUtils.readUTF8String((ByteBuf)buf);
                int angle = buf.readInt();
                this.signTypes[i] = new CustomAngleSign((ITextComponent)new TextComponentString(signName), angle);
                continue;
            }
            if (currentSign != 2) continue;
            signName = ByteBufUtils.readUTF8String((ByteBuf)buf);
            int xTargetPos = buf.readInt();
            int zTargetPos = buf.readInt();
            int xCurrentPos = buf.readInt();
            int zCurrentPos = buf.readInt();
            this.signTypes[i] = new CustomCoordinateSign((ITextComponent)new TextComponentString(signName), new BlockPos(xTargetPos, 0, zTargetPos), new BlockPos(xCurrentPos, 0, zCurrentPos));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.posX);
        buf.writeInt(this.posY);
        buf.writeInt(this.posZ);
        for (int i = 0; i < this.signTypes.length; ++i) {
            ISignType signType = this.signTypes[i];
            if (signType == null) {
                buf.writeInt(0);
                continue;
            }
            if (signType instanceof CustomAngleSign) {
                buf.writeInt(1);
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)signType.getText().func_150260_c());
                buf.writeInt(signType.getAngle());
                continue;
            }
            if (!(signType instanceof CustomCoordinateSign)) continue;
            buf.writeInt(2);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)signType.getText().func_150260_c());
            buf.writeInt(signType.getTarget().func_177958_n());
            buf.writeInt(signType.getTarget().func_177952_p());
            buf.writeInt(((CustomCoordinateSign)signType).getCurrent().func_177958_n());
            buf.writeInt(((CustomCoordinateSign)signType).getCurrent().func_177952_p());
        }
    }

    @Override
    public void handleClientSide(MessageUpdateSignpost message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(MessageUpdateSignpost message, EntityPlayer player) {
        BlockPos pos = new BlockPos(message.posX, message.posY, message.posZ);
        TileEntity tileentity = player.field_70170_p.func_175625_s(pos);
        if (tileentity instanceof TileEntitySignpost) {
            TileEntitySignpost tileEntitySignpost = (TileEntitySignpost)tileentity;
            ISignType[] newSigns = new ISignType[7];
            for (int i = 0; i < newSigns.length; ++i) {
                ISignType sign = null;
                if (i < message.signTypes.length) {
                    sign = message.signTypes[i];
                }
                newSigns[i] = sign;
            }
            tileEntitySignpost.signs = newSigns;
            tileEntitySignpost.func_70296_d();
            IBlockState iblockstate = player.field_70170_p.func_180495_p(pos);
            player.field_70170_p.func_184138_a(tileentity.func_174877_v(), iblockstate, iblockstate, 3);
        }
    }
}

