/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.customsignposts.signs;

import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.pavocado.customsignposts.signs.ISignType;
import net.pavocado.customsignposts.tileentity.TileEntitySignpost;

public class CustomCoordinateSign
implements ISignType {
    private final ITextComponent signText;
    private final BlockPos targetPos;
    private final BlockPos currentPos;

    public CustomCoordinateSign(ITextComponent text, BlockPos targetPos, BlockPos currentPos) {
        this.signText = text;
        this.targetPos = targetPos;
        this.currentPos = currentPos;
    }

    @Override
    public int getAngle() {
        return Math.floorMod((int)(Math.toDegrees(Math.atan2(this.currentPos.func_177952_p() - this.targetPos.func_177952_p(), this.targetPos.func_177958_n() - this.currentPos.func_177958_n())) + 360.0), 360);
    }

    @Override
    public ITextComponent getText() {
        return this.signText;
    }

    @Override
    public ITextComponent getDistanceText() {
        int distance = (int)Math.ceil(this.currentPos.func_185332_f(this.targetPos.func_177958_n(), this.currentPos.func_177956_o(), this.targetPos.func_177952_p()));
        return new TextComponentTranslation("customsignposts.distance", new Object[]{String.valueOf(distance)});
    }

    @Override
    public TileEntitySignpost.SignType getSignType() {
        return TileEntitySignpost.SignType.COORDINATE;
    }

    @Override
    public BlockPos getTarget() {
        return this.targetPos;
    }

    public BlockPos getCurrent() {
        return this.currentPos;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderText(FontRenderer fontrenderer, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)-2.0f, (float)0.0f);
        ITextComponent itextcomponent = this.getText();
        List list = GuiUtilRenderComponents.func_178908_a((ITextComponent)itextcomponent, (int)90, (FontRenderer)fontrenderer, (boolean)false, (boolean)true);
        String signText = !list.isEmpty() ? ((ITextComponent)list.get(0)).func_150254_d() : "";
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)5.0f, (float)0.0f, (float)4.5f);
        fontrenderer.func_78276_b(signText, -fontrenderer.func_78256_a(signText) / 2, 0, color);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-5.5f, (float)0.0f, (float)4.5f);
        fontrenderer.func_78276_b(signText, -fontrenderer.func_78256_a(signText) / 2, 0, color);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)1.0f);
        String distanceText = this.getDistanceText().func_150254_d();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)5.5f, (float)6.0f, (float)4.5f);
        fontrenderer.func_78276_b(distanceText, -fontrenderer.func_78256_a(distanceText) / 2, 5, color);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-6.0f, (float)6.0f, (float)4.5f);
        fontrenderer.func_78276_b(distanceText, -fontrenderer.func_78256_a(distanceText) / 2, 5, color);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }
}

