/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.customsignposts.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.pavocado.customsignposts.block.BlockSignpost;
import net.pavocado.customsignposts.signs.CustomAngleSign;
import net.pavocado.customsignposts.signs.CustomCoordinateSign;
import net.pavocado.customsignposts.signs.ISignType;

public class TileEntitySignpost
extends TileEntity {
    public ISignType[] signs = new ISignType[]{new CustomAngleSign((ITextComponent)new TextComponentString("Example Sign"), 90), null, null, null, null, null, null};

    public ResourceLocation getTexture() {
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = blockState.func_177230_c();
        if (block instanceof BlockSignpost) {
            return ((BlockSignpost)block).getSignTexture();
        }
        return BlockSignpost.OAK_SIGN;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        for (int i = 0; i < 7; ++i) {
            NBTTagCompound signCompound;
            if (this.signs[i] == null) {
                compound.func_74782_a("Sign_" + String.valueOf(i), (NBTBase)new NBTTagCompound());
                continue;
            }
            if (this.signs[i] instanceof CustomAngleSign) {
                signCompound = new NBTTagCompound();
                signCompound.func_74778_a("Name", this.signs[i].getText().func_150260_c());
                signCompound.func_74768_a("Angle", this.signs[i].getAngle());
                compound.func_74782_a("Sign_" + String.valueOf(i), (NBTBase)signCompound);
                continue;
            }
            if (!(this.signs[i] instanceof CustomCoordinateSign)) continue;
            signCompound = new NBTTagCompound();
            signCompound.func_74778_a("Name", this.signs[i].getText().func_150260_c());
            signCompound.func_74768_a("TargetX", this.signs[i].getTarget().func_177958_n());
            signCompound.func_74768_a("TargetZ", this.signs[i].getTarget().func_177952_p());
            compound.func_74782_a("Sign_" + String.valueOf(i), (NBTBase)signCompound);
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        ISignType[] newSigns = new ISignType[]{null, null, null, null, null, null, null};
        for (int i = 0; i < newSigns.length; ++i) {
            if (!compound.func_74764_b("Sign_" + String.valueOf(i))) continue;
            NBTTagCompound signInfo = compound.func_74775_l("Sign_" + String.valueOf(i));
            if (signInfo.func_74764_b("Angle")) {
                newSigns[i] = new CustomAngleSign((ITextComponent)new TextComponentString(signInfo.func_74779_i("Name")), signInfo.func_74762_e("Angle"));
                continue;
            }
            if (!signInfo.func_74764_b("TargetX")) continue;
            newSigns[i] = new CustomCoordinateSign((ITextComponent)new TextComponentString(signInfo.func_74779_i("Name")), new BlockPos(signInfo.func_74762_e("TargetX"), 0, signInfo.func_74762_e("TargetZ")), this.func_174877_v());
        }
        this.signs = newSigns;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbttagcompound = this.func_189515_b(new NBTTagCompound());
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbttagcompound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        if (pkt != null) {
            this.func_145839_a(pkt.func_148857_g());
        }
    }

    public static enum SignType {
        NONE,
        ANGLE,
        COORDINATE;


        public SignType next() {
            return SignType.values()[(this.ordinal() + 1) % SignType.values().length];
        }
    }
}

