/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.customsignposts.client;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.RenderComponentsUtil;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.customsignposts.client.ModelSignpostBoard;
import net.pavocado.customsignposts.init.SignpostBlocks;
import net.pavocado.customsignposts.tileentity.TileEntitySignpost;

@OnlyIn(value=Dist.CLIENT)
public class TileEntitySignpostRenderer
extends TileEntityRenderer<TileEntitySignpost> {
    private static final ResourceLocation ACACIA_SIGN_TEXTURE = new ResourceLocation("customsignposts:textures/signs/signpost_acacia.png");
    private static final ResourceLocation DARK_OAK_SIGN_TEXTURE = new ResourceLocation("customsignposts:textures/signs/signpost_dark_oak.png");
    private static final ResourceLocation JUNGLE_SIGN_TEXTURE = new ResourceLocation("customsignposts:textures/signs/signpost_jungle.png");
    private static final ResourceLocation BIRCH_SIGN_TEXTURE = new ResourceLocation("customsignposts:textures/signs/signpost_birch.png");
    private static final ResourceLocation OAK_SIGN_TEXTURE = new ResourceLocation("customsignposts:textures/signs/signpost_oak.png");
    private static final ResourceLocation SPRUCE_SIGN_TEXTURE = new ResourceLocation("customsignposts:textures/signs/signpost_spruce.png");
    private static final ResourceLocation COBBLESTONE_SIGN_TEXTURE = new ResourceLocation("customsignposts:textures/signs/signpost_cobblestone.png");
    private static final ResourceLocation NETHER_BRICKS_SIGN_TEXTURE = new ResourceLocation("customsignposts:textures/signs/signpost_nether_bricks.png");
    private static final ResourceLocation SANDSTONE_SIGN_TEXTURE = new ResourceLocation("customsignposts:textures/signs/signpost_sandstone.png");
    private static final ResourceLocation RED_SANDSTONE_SIGN_TEXTURE = new ResourceLocation("customsignposts:textures/signs/signpost_red_sandstone.png");
    private static final ResourceLocation PURPUR_SIGN_TEXTURE = new ResourceLocation("customsignposts:textures/signs/signpost_purpur.png");
    private static final ResourceLocation END_STONE_BRICKS_SIGN_TEXTURE = new ResourceLocation("customsignposts:textures/signs/signpost_end_stone_bricks.png");
    private static final ResourceLocation STONE_BRICKS_SIGN_TEXTURE = new ResourceLocation("customsignposts:textures/signs/signpost_stone_bricks.png");
    private static final ResourceLocation MOSSY_STONE_BRICKS_SIGN_TEXTURE = new ResourceLocation("customsignposts:textures/signs/signpost_mossy_stone_bricks.png");
    private final ModelSignpostBoard signBoard = new ModelSignpostBoard();

    public void render(TileEntitySignpost tileEntitySignpost, double x, double y, double z, float partialTicks, int destroyStage) {
        BlockState blockstate = tileEntitySignpost.func_195044_w();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)4.0f, (float)2.0f, (float)1.0f);
            GlStateManager.translatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.matrixMode((int)5888);
        }
        GlStateManager.enableRescaleNormal();
        FontRenderer fontrenderer = this.func_147498_b();
        HashMap<Integer, Integer> mappedValues = new HashMap<Integer, Integer>();
        for (int j = 0; j < 7; ++j) {
            byte signType = tileEntitySignpost.signType[j];
            if (signType == 0) continue;
            int angle = 0;
            String distanceText = "";
            if (signType == 1) {
                angle = 360 - tileEntitySignpost.angles[j];
            } else if (signType == 2) {
                BlockPos target = tileEntitySignpost.targets[j];
                BlockPos current = tileEntitySignpost.getZeroPos();
                angle = Math.floorMod((int)(Math.toDegrees(Math.atan2(current.func_177952_p() - target.func_177952_p(), target.func_177958_n() - current.func_177958_n())) + 360.0), 360);
                int distance = (int)Math.ceil(Math.sqrt(current.func_177951_i((Vec3i)target)));
                distanceText = new TranslationTextComponent("customsignposts.distance", new Object[]{String.valueOf(distance)}).func_150254_d();
            }
            int roundedAngle = Math.floorMod(Math.round(angle / 60) * 60, 360);
            int signOffset = 0;
            if (mappedValues.containsKey(roundedAngle)) {
                signOffset = (Integer)mappedValues.get(roundedAngle) + 1;
                mappedValues.put(roundedAngle, signOffset);
            } else {
                mappedValues.put(roundedAngle, 0);
            }
            GlStateManager.pushMatrix();
            GlStateManager.rotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translatef((float)0.0f, (float)(-0.15f - (float)signOffset * 0.25f), (float)0.0f);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)0.6666667f, (float)-0.6666667f, (float)-0.6666667f);
            if (destroyStage < 0) {
                this.func_147499_a(this.getSignTexture(blockstate.func_177230_c()));
            }
            this.signBoard.render();
            GlStateManager.popMatrix();
            GlStateManager.translatef((float)0.65f, (float)0.52f, (float)0.046666667f);
            GlStateManager.scalef((float)0.010416667f, (float)-0.010416667f, (float)0.010416667f);
            GlStateManager.normal3f((float)0.0f, (float)0.0f, (float)-0.010416667f);
            GlStateManager.depthMask((boolean)false);
            if (destroyStage < 0) {
                int color = tileEntitySignpost.getTextColor().func_218388_g();
                String signText = tileEntitySignpost.getRenderText(j, textComponent -> {
                    List list = RenderComponentsUtil.func_178908_a((ITextComponent)textComponent, (int)90, (FontRenderer)fontrenderer, (boolean)false, (boolean)true);
                    return list.isEmpty() ? "" : ((ITextComponent)list.get(0)).func_150254_d();
                });
                if (signText != null) {
                    GlStateManager.pushMatrix();
                    if (signType == 2) {
                        GlStateManager.translatef((float)0.0f, (float)-3.0f, (float)0.0f);
                        GlStateManager.pushMatrix();
                        GlStateManager.scalef((float)0.6f, (float)0.6f, (float)1.0f);
                        GlStateManager.translatef((float)0.0f, (float)16.0f, (float)0.0f);
                        fontrenderer.func_211126_b(distanceText, (float)(-fontrenderer.func_78256_a(distanceText) / 2), 0.0f, color);
                        GlStateManager.popMatrix();
                    }
                    fontrenderer.func_211126_b(signText, (float)(-fontrenderer.func_78256_a(signText) / 2), 0.0f, color);
                    GlStateManager.popMatrix();
                    GlStateManager.pushMatrix();
                    GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.translatef((float)0.0f, (float)0.0f, (float)8.5f);
                    if (signType == 2) {
                        GlStateManager.translatef((float)0.0f, (float)-3.0f, (float)0.0f);
                        GlStateManager.pushMatrix();
                        GlStateManager.scalef((float)0.6f, (float)0.6f, (float)1.0f);
                        GlStateManager.translatef((float)0.0f, (float)16.0f, (float)0.0f);
                        fontrenderer.func_211126_b(distanceText, (float)(-fontrenderer.func_78256_a(distanceText) / 2), 0.0f, color);
                        GlStateManager.popMatrix();
                    }
                    fontrenderer.func_211126_b(signText, (float)(-fontrenderer.func_78256_a(signText) / 2), 0.0f, color);
                    GlStateManager.popMatrix();
                }
            }
            GlStateManager.depthMask((boolean)true);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.popMatrix();
        }
        GlStateManager.popMatrix();
        if (destroyStage >= 0) {
            GlStateManager.matrixMode((int)5890);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
        }
    }

    private ResourceLocation getSignTexture(Block block) {
        if (block == SignpostBlocks.OAK_SIGNPOST.get()) {
            return OAK_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.SPRUCE_SIGNPOST.get()) {
            return SPRUCE_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.JUNGLE_SIGNPOST.get()) {
            return JUNGLE_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.ACACIA_SIGNPOST.get()) {
            return ACACIA_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.BIRCH_SIGNPOST.get()) {
            return BIRCH_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.DARK_OAK_SIGNPOST.get()) {
            return DARK_OAK_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.COBBLESTONE_SIGNPOST.get()) {
            return COBBLESTONE_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.NETHER_BRICKS_SIGNPOST.get()) {
            return NETHER_BRICKS_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.SANDSTONE_SIGNPOST.get()) {
            return SANDSTONE_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.RED_SANDSTONE_SIGNPOST.get()) {
            return RED_SANDSTONE_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.PURPUR_SIGNPOST.get()) {
            return PURPUR_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.END_STONE_BRICKS_SIGNPOST.get()) {
            return END_STONE_BRICKS_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.STONE_BRICKS_SIGNPOST.get()) {
            return STONE_BRICKS_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.MOSSY_STONE_BRICKS_SIGNPOST.get()) {
            return MOSSY_STONE_BRICKS_SIGN_TEXTURE;
        }
        return OAK_SIGN_TEXTURE;
    }
}

