/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.customsignposts.network;

import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.pavocado.customsignposts.tileentity.TileEntitySignpost;

public class PacketUpdateSignpost {
    BlockPos entityPos;
    ITextComponent[] signText;
    int[] angles;
    BlockPos[] targets;
    byte[] signType;

    public PacketUpdateSignpost(BlockPos entityPosIn, ITextComponent[] signTextIn, int[] anglesIn, BlockPos[] targetsIn, byte[] signTypeIn) {
        this.entityPos = entityPosIn;
        this.signText = signTextIn;
        this.angles = anglesIn;
        this.targets = targetsIn;
        this.signType = signTypeIn;
    }

    public static void encode(PacketUpdateSignpost message, PacketBuffer buffer) {
        int i;
        buffer.func_179255_a(message.entityPos);
        for (i = 0; i < 7; ++i) {
            buffer.func_180714_a(ITextComponent.Serializer.func_150696_a((ITextComponent)message.signText[i]));
        }
        for (i = 0; i < 7; ++i) {
            buffer.writeInt(message.angles[i]);
        }
        for (i = 0; i < 7; ++i) {
            buffer.func_179255_a(message.targets[i]);
        }
        for (i = 0; i < 7; ++i) {
            buffer.writeByte((int)message.signType[i]);
        }
    }

    public static PacketUpdateSignpost decode(PacketBuffer buffer) {
        int i;
        BlockPos entityPos = buffer.func_179259_c();
        ITextComponent[] signText = new ITextComponent[]{new StringTextComponent(""), new StringTextComponent(""), new StringTextComponent(""), new StringTextComponent(""), new StringTextComponent(""), new StringTextComponent(""), new StringTextComponent("")};
        int[] angles = new int[]{0, 0, 0, 0, 0, 0, 0};
        BlockPos[] targets = new BlockPos[]{BlockPos.field_177992_a, BlockPos.field_177992_a, BlockPos.field_177992_a, BlockPos.field_177992_a, BlockPos.field_177992_a, BlockPos.field_177992_a, BlockPos.field_177992_a};
        byte[] signType = new byte[]{0, 0, 0, 0, 0, 0, 0};
        for (i = 0; i < 7; ++i) {
            ITextComponent itextcomponent;
            String s = buffer.func_150789_c(256);
            signText[i] = itextcomponent = ITextComponent.Serializer.func_150699_a((String)(s.isEmpty() ? "\"\"" : s));
        }
        for (i = 0; i < 7; ++i) {
            angles[i] = buffer.readInt();
        }
        for (i = 0; i < 7; ++i) {
            targets[i] = buffer.func_179259_c();
        }
        for (i = 0; i < 7; ++i) {
            signType[i] = buffer.readByte();
        }
        return new PacketUpdateSignpost(entityPos, signText, angles, targets, signType);
    }

    public static void handle(PacketUpdateSignpost packet, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (sender != null) {
                TileEntity tileentity = sender.field_70170_p.func_175625_s(packet.entityPos);
                if (tileentity instanceof TileEntitySignpost) {
                    TileEntitySignpost tileEntitySignpost = (TileEntitySignpost)tileentity;
                    for (int i = 0; i < 7; ++i) {
                        tileEntitySignpost.setLine(i, packet.signType[i], packet.signText[i], packet.angles[i], packet.targets[i]);
                    }
                }
                BlockState blockState = sender.field_70170_p.func_180495_p(packet.entityPos);
                sender.field_70170_p.func_184138_a(packet.entityPos, blockState, blockState, 3);
            }
        });
    }
}

