/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.customsignposts.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.pavocado.customsignposts.client.ScreenSignpost;
import net.pavocado.customsignposts.init.SignpostBlocks;
import net.pavocado.customsignposts.tileentity.TileEntitySignpost;

public class BlockSignpost
extends ContainerBlock
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    protected static final VoxelShape POLE_SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public BlockSignpost(AbstractBlock.Properties blockProperties) {
        super(blockProperties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.func_177229_b(HALF);
        if (facing.func_176740_k() != Direction.Axis.Y || doubleblockhalf == DoubleBlockHalf.LOWER != (facing == Direction.UP) || facingState.func_177230_c() == this && facingState.func_177229_b(HALF) != doubleblockhalf) {
            return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        boolean canDye;
        ItemStack itemstack = player.func_184586_b(handIn);
        boolean bl = canDye = itemstack.func_77973_b() instanceof DyeItem && player.field_71075_bZ.field_75099_e;
        if (worldIn.field_72995_K) {
            if (!canDye) {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> BlockSignpost.displayGUIScreen(state, worldIn, pos));
                return ActionResultType.CONSUME;
            }
            return ActionResultType.SUCCESS;
        }
        BlockPos blockpos = state.func_177229_b(HALF) == DoubleBlockHalf.UPPER ? pos : pos.func_177984_a();
        TileEntity tileentity = worldIn.func_175625_s(blockpos);
        if (tileentity instanceof TileEntitySignpost) {
            TileEntitySignpost signtileentity;
            boolean flag1;
            if (canDye && (flag1 = (signtileentity = (TileEntitySignpost)tileentity).setTextColor(((DyeItem)itemstack.func_77973_b()).func_195962_g())) && !player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void displayGUIScreen(BlockState state, World worldIn, BlockPos pos) {
        BlockPos blockpos;
        TileEntity tileEntity;
        if (worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(blockpos = state.func_177229_b(HALF) == DoubleBlockHalf.UPPER ? pos : pos.func_177984_a())) instanceof TileEntitySignpost && ((TileEntitySignpost)tileEntity).isEditable) {
            Minecraft.func_71410_x().func_147108_a((Screen)new ScreenSignpost((TileEntitySignpost)tileEntity));
        }
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return POLE_SHAPE;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        return blockpos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(blockpos.func_177984_a()).func_196953_a(context) ? super.func_196258_a(context) : null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileEntity;
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        if (!worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(pos.func_177984_a())) instanceof TileEntitySignpost) {
            ((TileEntitySignpost)tileEntity).setTextColor(this.getSignColour(state.func_177230_c()));
        }
    }

    private DyeColor getSignColour(Block block) {
        if (block == SignpostBlocks.SPRUCE_SIGNPOST.get()) {
            return DyeColor.WHITE;
        }
        if (block == SignpostBlocks.DARK_OAK_SIGNPOST.get()) {
            return DyeColor.LIGHT_GRAY;
        }
        if (block == SignpostBlocks.NETHER_BRICKS_SIGNPOST.get()) {
            return DyeColor.WHITE;
        }
        if (block == SignpostBlocks.BLACKSTONE_SIGNPOST.get()) {
            return DyeColor.WHITE;
        }
        if (block == SignpostBlocks.POLISHED_BLACKSTONE_BRICKS_SIGNPOST.get()) {
            return DyeColor.WHITE;
        }
        return DyeColor.BLACK;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return true;
        }
        return blockstate.func_177230_c() == this;
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, Blocks.field_150350_a.func_176223_P(), te, stack);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.func_177229_b(HALF);
        BlockPos blockpos = doubleblockhalf == DoubleBlockHalf.LOWER ? pos.func_177984_a() : pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == this && blockstate.func_177229_b(HALF) != doubleblockhalf) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
            if (!worldIn.field_72995_K && !player.func_184812_l_()) {
                BlockSignpost.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)player.func_184614_ca());
                BlockSignpost.func_220054_a((BlockState)blockstate, (World)worldIn, (BlockPos)blockpos, null, (Entity)player, (ItemStack)player.func_184614_ca());
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HALF, WATERLOGGED});
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (state.func_177229_b(HALF) == DoubleBlockHalf.UPPER) {
            return this.func_196283_a_(world);
        }
        return null;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntitySignpost();
    }
}

