/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.customsignposts.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.customsignposts.init.SignpostPacketHandler;
import net.pavocado.customsignposts.network.PacketUpdateSignpost;
import net.pavocado.customsignposts.tileentity.TileEntitySignpost;

@OnlyIn(value=Dist.CLIENT)
public class ScreenSignpost
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("customsignposts:textures/gui/signpost.png");
    private final int xSize = 256;
    private final int ySize = 204;
    private int guiLeft;
    private int guiTop;
    private FinaliseButton doneButton;
    private List<SignInput> signInputs;
    private final TileEntitySignpost signpostEntity;

    public ScreenSignpost(TileEntitySignpost tileEntitySignpost) {
        super(tileEntitySignpost.func_145748_c_());
        this.signpostEntity = tileEntitySignpost;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.field_230710_m_.clear();
        this.guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        this.guiTop = (this.field_230709_l_ - this.ySize) / 2;
        this.func_230480_a_((Widget)new FinaliseButton(this.guiLeft + 142, this.guiTop + 178, (ITextComponent)new TranslationTextComponent("gui.cancel"), button -> this.field_230706_i_.func_147108_a(null)));
        this.doneButton = (FinaliseButton)this.func_230480_a_((Widget)new FinaliseButton(this.guiLeft + 198, this.guiTop + 178, (ITextComponent)new TranslationTextComponent("gui.done"), button -> this.saveAndClose()));
        this.signInputs = new ArrayList<SignInput>();
        for (int i = 0; i < 7; ++i) {
            SignInput signInput = new SignInput(this, i * 23);
            this.signInputs.add(signInput);
            signInput.nameField.func_146180_a(this.signpostEntity.signText[i].getString());
            signInput.coordXField.func_146180_a(String.valueOf(this.signpostEntity.targets[i].func_177958_n()));
            signInput.coordZField.func_146180_a(String.valueOf(this.signpostEntity.targets[i].func_177952_p()));
            signInput.angleSlider.setValue(this.signpostEntity.angles[i]);
            switch (this.signpostEntity.signType[i]) {
                case 0: {
                    signInput.currentSignType = TileEntitySignpost.SignType.NONE;
                    break;
                }
                case 1: {
                    signInput.currentSignType = TileEntitySignpost.SignType.ANGLE;
                    break;
                }
                case 2: {
                    signInput.currentSignType = TileEntitySignpost.SignType.COORDINATE;
                }
            }
            signInput.updateOptions();
        }
    }

    public void saveAndClose() {
        ITextComponent[] signText = new ITextComponent[]{new StringTextComponent(""), new StringTextComponent(""), new StringTextComponent(""), new StringTextComponent(""), new StringTextComponent(""), new StringTextComponent(""), new StringTextComponent("")};
        int[] angles = new int[]{0, 0, 0, 0, 0, 0, 0};
        BlockPos[] targets = new BlockPos[]{BlockPos.field_177992_a, BlockPos.field_177992_a, BlockPos.field_177992_a, BlockPos.field_177992_a, BlockPos.field_177992_a, BlockPos.field_177992_a, BlockPos.field_177992_a};
        byte[] signType = new byte[]{0, 0, 0, 0, 0, 0, 0};
        block7: for (int i = 0; i < 7; ++i) {
            int targetZ;
            int targetX;
            signText[i] = new TranslationTextComponent(this.signInputs.get((int)i).nameField.func_146179_b());
            angles[i] = this.signInputs.get((int)i).angleSlider.getValue();
            try {
                targetX = Integer.parseInt(this.signInputs.get((int)i).coordXField.func_146179_b());
                targetZ = Integer.parseInt(this.signInputs.get((int)i).coordZField.func_146179_b());
            }
            catch (NumberFormatException ex) {
                targetX = 0;
                targetZ = 0;
            }
            targets[i] = new BlockPos(targetX, 0, targetZ);
            switch (this.signInputs.get((int)i).currentSignType) {
                case NONE: {
                    signType[i] = 0;
                    continue block7;
                }
                case ANGLE: {
                    signType[i] = 1;
                    continue block7;
                }
                case COORDINATE: {
                    signType[i] = 2;
                }
            }
        }
        SignpostPacketHandler.INSTANCE.sendToServer((Object)new PacketUpdateSignpost(this.signpostEntity.func_174877_v(), signText, angles, targets, signType));
        this.field_230706_i_.func_147108_a(null);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.drawScreen(matrixStack, mouseX, mouseY);
        for (SignInput signInput : this.signInputs) {
            signInput.render(this, matrixStack, mouseX, mouseY, partialTicks);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void drawScreen(MatrixStack matrixStack, int mouseX, int mouseY) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        this.func_238474_b_(matrixStack, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        String s = this.field_230704_d_.getString();
        this.field_230712_o_.func_238421_b_(matrixStack, s, (float)(this.guiLeft + this.xSize / 2 - this.field_230712_o_.func_78256_a(s) / 2), (float)(this.guiTop + 6), 0x404040);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        for (SignInput signInput : this.signInputs) {
            for (TextFieldWidget textFieldWidget : signInput.textFieldArray) {
                textFieldWidget.func_146178_a();
            }
        }
    }

    public void func_231152_a_(Minecraft minecraft, int width, int height) {
        List<SignInput> tempInput = this.signInputs;
        this.func_231158_b_(minecraft, width, height);
        int i = 0;
        for (SignInput signInput : this.signInputs) {
            signInput.reapplyData(tempInput.get(i++));
        }
    }

    public boolean func_231042_a_(char charIn, int keyCode) {
        boolean value = super.func_231042_a_(charIn, keyCode);
        for (SignInput signInput : this.signInputs) {
            signInput.coordXField.func_146180_a(signInput.coordXField.func_146179_b().replaceAll("[^-?0-9]", ""));
            signInput.coordZField.func_146180_a(signInput.coordZField.func_146179_b().replaceAll("[^-?0-9]", ""));
        }
        return value;
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    static class SignInput {
        Button signButton;
        AngleSlider angleSlider;
        TextFieldWidget nameField;
        TextFieldWidget coordXField;
        TextFieldWidget coordZField;
        TextFieldWidget[] textFieldArray;
        TileEntitySignpost.SignType currentSignType = TileEntitySignpost.SignType.NONE;
        int posX;
        int posY;

        public SignInput(ScreenSignpost screenSignpost, int yOffset) {
            this.posX = screenSignpost.guiLeft;
            this.posY = screenSignpost.guiTop + yOffset;
            this.signButton = (Button)screenSignpost.func_230480_a_((Widget)new Button(this.posX + 7, this.posY + 16, 44, 20, StringTextComponent.field_240750_d_, button -> {
                this.currentSignType = TileEntitySignpost.SignType.next(this.currentSignType);
                this.updateOptions();
            }));
            this.angleSlider = (AngleSlider)screenSignpost.func_230480_a_((Widget)new AngleSlider(this.posX + 150, this.posY + 16));
            FontRenderer fontRenderer = screenSignpost.field_230712_o_;
            screenSignpost.field_230712_o_.getClass();
            this.nameField = new TextFieldWidget(fontRenderer, this.posX + 58, this.posY + 21, 80, 9, (ITextComponent)new TranslationTextComponent("itemGroup.search"));
            FontRenderer fontRenderer2 = screenSignpost.field_230712_o_;
            screenSignpost.field_230712_o_.getClass();
            this.coordXField = new TextFieldWidget(fontRenderer2, this.posX + 162, this.posY + 21, 35, 9, (ITextComponent)new TranslationTextComponent("itemGroup.search"));
            FontRenderer fontRenderer3 = screenSignpost.field_230712_o_;
            screenSignpost.field_230712_o_.getClass();
            this.coordZField = new TextFieldWidget(fontRenderer3, this.posX + 213, this.posY + 21, 35, 9, (ITextComponent)new TranslationTextComponent("itemGroup.search"));
            this.textFieldArray = new TextFieldWidget[]{this.nameField, this.coordXField, this.coordZField};
            this.nameField.func_146203_f(16);
            this.coordXField.func_146203_f(9);
            this.coordZField.func_146203_f(9);
            for (TextFieldWidget textField : this.textFieldArray) {
                textField.func_146185_a(false);
                textField.func_146189_e(true);
                textField.func_146193_g(0xFFFFFF);
                textField.func_146205_d(true);
                screenSignpost.field_230705_e_.add(textField);
            }
            this.updateOptions();
        }

        public void render(ScreenSignpost screenSignpost, MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            switch (this.currentSignType) {
                case NONE: {
                    GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    screenSignpost.getMinecraft().func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
                    screenSignpost.func_238474_b_(matrixStack, this.posX + 56, this.posY + 19, 0, 204, 90, 13);
                    break;
                }
                case COORDINATE: {
                    GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    screenSignpost.getMinecraft().func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
                    screenSignpost.func_238474_b_(matrixStack, this.posX + 159, this.posY + 19, 0, 217, 90, 13);
                    String xString = "X:";
                    screenSignpost.field_230712_o_.func_238421_b_(matrixStack, xString, (float)(this.posX + 159 - screenSignpost.field_230712_o_.func_78256_a(xString)), (float)(this.posY + 22), 0x404040);
                    String zString = "Z:";
                    screenSignpost.field_230712_o_.func_238421_b_(matrixStack, zString, (float)(this.posX + 210 - screenSignpost.field_230712_o_.func_78256_a(zString)), (float)(this.posY + 22), 0x404040);
                }
            }
            this.nameField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.coordXField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            this.coordZField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }

        public void reapplyData(SignInput inputInput) {
            this.currentSignType = inputInput.currentSignType;
            this.nameField.func_146180_a(inputInput.nameField.func_146179_b());
            this.coordXField.func_146180_a(inputInput.coordXField.func_146179_b());
            this.coordZField.func_146180_a(inputInput.coordZField.func_146179_b());
            this.angleSlider.setValue(inputInput.angleSlider.getValue());
            this.updateOptions();
        }

        public void updateOptions() {
            this.nameField.func_146189_e(false);
            this.coordXField.func_146189_e(false);
            this.coordZField.func_146189_e(false);
            this.angleSlider.field_230694_p_ = false;
            switch (this.currentSignType) {
                case NONE: {
                    this.signButton.func_238482_a_((ITextComponent)new TranslationTextComponent("gui.none"));
                    break;
                }
                case ANGLE: {
                    this.nameField.func_146189_e(true);
                    this.angleSlider.field_230694_p_ = true;
                    this.signButton.func_238482_a_((ITextComponent)new TranslationTextComponent("customsignposts.angle"));
                    break;
                }
                case COORDINATE: {
                    this.nameField.func_146189_e(true);
                    this.coordXField.func_146189_e(true);
                    this.coordZField.func_146189_e(true);
                    this.signButton.func_238482_a_((ITextComponent)new TranslationTextComponent("customsignposts.coord"));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class AngleSlider
    extends AbstractSlider {
        public AngleSlider(int xIn, int yIn) {
            super(xIn, yIn, 98, 20, StringTextComponent.field_240750_d_, 0.0);
            this.func_230979_b_();
        }

        protected void func_230979_b_() {
            this.func_238482_a_((ITextComponent)new TranslationTextComponent("customsignposts.bearing", new Object[]{(int)((float)this.field_230683_b_ * 360.0f)}));
        }

        protected void func_230972_a_() {
        }

        protected void setValue(int val) {
            this.field_230683_b_ = MathHelper.func_151237_a((double)((double)val / 360.0), (double)0.0, (double)1.0);
            this.func_230979_b_();
        }

        protected int getValue() {
            return (int)((float)this.field_230683_b_ * 360.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FinaliseButton
    extends Button {
        public FinaliseButton(int xIn, int yIn, ITextComponent text, Button.IPressable onPress) {
            super(xIn, yIn, 50, 20, text, onPress);
        }
    }
}

