/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.customsignposts.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.customsignposts.client.ModelSignpostBoard;
import net.pavocado.customsignposts.init.SignpostBlocks;
import net.pavocado.customsignposts.tileentity.TileEntitySignpost;

@OnlyIn(value=Dist.CLIENT)
public class TileEntitySignpostRenderer
extends TileEntityRenderer<TileEntitySignpost> {
    public static final ResourceLocation ACACIA_SIGN_TEXTURE = new ResourceLocation("customsignposts", "signs/signpost_acacia");
    public static final ResourceLocation DARK_OAK_SIGN_TEXTURE = new ResourceLocation("customsignposts", "signs/signpost_dark_oak");
    public static final ResourceLocation JUNGLE_SIGN_TEXTURE = new ResourceLocation("customsignposts", "signs/signpost_jungle");
    public static final ResourceLocation BIRCH_SIGN_TEXTURE = new ResourceLocation("customsignposts", "signs/signpost_birch");
    public static final ResourceLocation OAK_SIGN_TEXTURE = new ResourceLocation("customsignposts", "signs/signpost_oak");
    public static final ResourceLocation SPRUCE_SIGN_TEXTURE = new ResourceLocation("customsignposts", "signs/signpost_spruce");
    public static final ResourceLocation COBBLESTONE_SIGN_TEXTURE = new ResourceLocation("customsignposts", "signs/signpost_cobblestone");
    public static final ResourceLocation NETHER_BRICKS_SIGN_TEXTURE = new ResourceLocation("customsignposts", "signs/signpost_nether_bricks");
    public static final ResourceLocation SANDSTONE_SIGN_TEXTURE = new ResourceLocation("customsignposts", "signs/signpost_sandstone");
    public static final ResourceLocation RED_SANDSTONE_SIGN_TEXTURE = new ResourceLocation("customsignposts", "signs/signpost_red_sandstone");
    public static final ResourceLocation PURPUR_SIGN_TEXTURE = new ResourceLocation("customsignposts", "signs/signpost_purpur");
    public static final ResourceLocation END_STONE_BRICKS_SIGN_TEXTURE = new ResourceLocation("customsignposts", "signs/signpost_end_stone_bricks");
    public static final ResourceLocation STONE_BRICKS_SIGN_TEXTURE = new ResourceLocation("customsignposts", "signs/signpost_stone_bricks");
    public static final ResourceLocation MOSSY_STONE_BRICKS_SIGN_TEXTURE = new ResourceLocation("customsignposts", "signs/signpost_mossy_stone_bricks");
    public static final ResourceLocation CRIMSON_SIGN_TEXTURE = new ResourceLocation("customsignposts", "signs/signpost_crimson");
    public static final ResourceLocation WARPED_SIGN_TEXTURE = new ResourceLocation("customsignposts", "signs/signpost_warped");
    public static final ResourceLocation STONE_SIGN_TEXTURE = new ResourceLocation("customsignposts", "signs/signpost_stone");
    public static final ResourceLocation PRISMARINE_BRICKS_SIGN_TEXTURE = new ResourceLocation("customsignposts", "signs/signpost_prismarine_bricks");
    public static final ResourceLocation BLACKSTONE_SIGN_TEXTURE = new ResourceLocation("customsignposts", "signs/signpost_blackstone");
    public static final ResourceLocation POLISHED_BLACKSTONE_BRICKS_SIGN_TEXTURE = new ResourceLocation("customsignposts", "signs/signpost_polished_blackstone_bricks");
    public static final ResourceLocation MOSSY_COBBLESTONE_SIGN_TEXTURE = new ResourceLocation("customsignposts", "signs/signpost_mossy_cobblestone");
    private final ModelSignpostBoard signBoard = new ModelSignpostBoard();

    public TileEntitySignpostRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(TileEntitySignpost tileEntitySignpost, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLightIn, int packedOverlayIn) {
        BlockState blockstate = tileEntitySignpost.func_195044_w();
        FontRenderer fontrenderer = this.field_228858_b_.func_147548_a();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        HashMap<Integer, Integer> mappedValues = new HashMap<Integer, Integer>();
        for (int j = 0; j < 7; ++j) {
            byte signType = tileEntitySignpost.signType[j];
            if (signType == 0) continue;
            int angle = 0;
            int distance = 0;
            if (signType == 1) {
                angle = 360 - tileEntitySignpost.angles[j];
            } else if (signType == 2) {
                BlockPos target = tileEntitySignpost.targets[j];
                BlockPos current = tileEntitySignpost.getZeroPos();
                angle = Math.floorMod((int)(Math.toDegrees(Math.atan2(current.func_177952_p() - target.func_177952_p(), target.func_177958_n() - current.func_177958_n())) + 360.0), 360);
                distance = (int)Math.ceil(Math.sqrt(current.func_177951_i((Vector3i)target)));
            }
            int roundedAngle = Math.floorMod(Math.round(angle / 60) * 60, 360);
            int signOffset = 0;
            if (mappedValues.containsKey(roundedAngle)) {
                signOffset = (Integer)mappedValues.get(roundedAngle) + 1;
                mappedValues.put(roundedAngle, signOffset);
            } else {
                mappedValues.put(roundedAngle, 0);
            }
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)angle));
            matrixStack.func_227861_a_(0.0, (double)(-0.15f - (float)signOffset * 0.25f), 0.0);
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.6666667f, -0.6666667f, -0.6666667f);
            RenderMaterial lvt_9_3_ = TileEntitySignpostRenderer.getMaterial(blockstate.func_177230_c());
            IVertexBuilder vertexBuilder = lvt_9_3_.func_229311_a_(buffer, arg_0 -> ((ModelSignpostBoard)this.signBoard).func_228282_a_(arg_0));
            this.signBoard.board.func_228308_a_(matrixStack, vertexBuilder, packedLightIn, packedOverlayIn);
            matrixStack.func_227865_b_();
            int textColour = tileEntitySignpost.getTextColor().func_218388_g();
            int red = (int)((double)NativeImage.func_227791_b_((int)textColour) * 0.4);
            int green = (int)((double)NativeImage.func_227793_c_((int)textColour) * 0.4);
            int blue = (int)((double)NativeImage.func_227795_d_((int)textColour) * 0.4);
            int combinedColour = NativeImage.func_227787_a_((int)0, (int)blue, (int)green, (int)red);
            IReorderingProcessor processor = tileEntitySignpost.getRenderText(j, properties -> {
                List processorList = fontrenderer.func_238425_b_((ITextProperties)properties, 90);
                return processorList.isEmpty() ? IReorderingProcessor.field_242232_a : (IReorderingProcessor)processorList.get(0);
            });
            if (processor != null) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)0.65f, (double)0.52f, 0.046666666865348816);
                matrixStack.func_227862_a_(0.010416667f, -0.010416667f, 0.010416667f);
                this.drawSignMessage(matrixStack, fontrenderer, signType, processor, combinedColour, buffer, packedLightIn);
                this.drawTarget(matrixStack, fontrenderer, signType, distance, combinedColour, buffer, packedLightIn);
                matrixStack.func_227860_a_();
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                matrixStack.func_227861_a_(0.0, 0.0, 8.5);
                this.drawSignMessage(matrixStack, fontrenderer, signType, processor, combinedColour, buffer, packedLightIn);
                this.drawTarget(matrixStack, fontrenderer, signType, distance, combinedColour, buffer, packedLightIn);
                matrixStack.func_227865_b_();
                matrixStack.func_227865_b_();
            }
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    private void drawTarget(MatrixStack matrixStack, FontRenderer fontrenderer, int signType, int distance, int combinedColour, IRenderTypeBuffer buffer, int packedLightIn) {
        if (signType == 2) {
            IReorderingProcessor processor;
            List processorList = fontrenderer.func_238425_b_((ITextProperties)new TranslationTextComponent("customsignposts.distance", new Object[]{distance}), 90);
            IReorderingProcessor iReorderingProcessor = processor = processorList.isEmpty() ? IReorderingProcessor.field_242232_a : (IReorderingProcessor)processorList.get(0);
            if (processor != null) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0, -3.0, 0.0);
                matrixStack.func_227862_a_(0.6f, 0.6f, 1.0f);
                matrixStack.func_227861_a_(0.0, 16.0, 0.0);
                float xOffset = (float)(-fontrenderer.func_243245_a(processor)) / 2.0f;
                fontrenderer.func_238416_a_(processor, xOffset, 0.0f, combinedColour, false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, packedLightIn);
                matrixStack.func_227865_b_();
            }
        }
    }

    private void drawSignMessage(MatrixStack matrixStack, FontRenderer fontrenderer, int signType, IReorderingProcessor processor, int combinedColour, IRenderTypeBuffer buffer, int packedLightIn) {
        float xOffset = (float)(-fontrenderer.func_243245_a(processor)) / 2.0f;
        matrixStack.func_227860_a_();
        if (signType == 2) {
            matrixStack.func_227861_a_(0.0, -3.0, 0.0);
        }
        fontrenderer.func_238416_a_(processor, xOffset, 0.0f, combinedColour, false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, packedLightIn);
        matrixStack.func_227865_b_();
    }

    public static RenderMaterial getMaterial(Block block) {
        return new RenderMaterial(Atlases.field_228746_e_, TileEntitySignpostRenderer.getSignTexture(block));
    }

    private static ResourceLocation getSignTexture(Block block) {
        if (block == SignpostBlocks.OAK_SIGNPOST.get()) {
            return OAK_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.SPRUCE_SIGNPOST.get()) {
            return SPRUCE_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.JUNGLE_SIGNPOST.get()) {
            return JUNGLE_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.ACACIA_SIGNPOST.get()) {
            return ACACIA_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.BIRCH_SIGNPOST.get()) {
            return BIRCH_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.DARK_OAK_SIGNPOST.get()) {
            return DARK_OAK_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.COBBLESTONE_SIGNPOST.get()) {
            return COBBLESTONE_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.NETHER_BRICKS_SIGNPOST.get()) {
            return NETHER_BRICKS_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.SANDSTONE_SIGNPOST.get()) {
            return SANDSTONE_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.RED_SANDSTONE_SIGNPOST.get()) {
            return RED_SANDSTONE_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.PURPUR_SIGNPOST.get()) {
            return PURPUR_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.END_STONE_BRICKS_SIGNPOST.get()) {
            return END_STONE_BRICKS_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.STONE_BRICKS_SIGNPOST.get()) {
            return STONE_BRICKS_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.MOSSY_STONE_BRICKS_SIGNPOST.get()) {
            return MOSSY_STONE_BRICKS_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.CRIMSON_SIGNPOST.get()) {
            return CRIMSON_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.WARPED_SIGNPOST.get()) {
            return WARPED_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.STONE_SIGNPOST.get()) {
            return STONE_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.PRISMARINE_BRICKS_SIGNPOST.get()) {
            return PRISMARINE_BRICKS_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.BLACKSTONE_SIGNPOST.get()) {
            return BLACKSTONE_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.POLISHED_BLACKSTONE_BRICKS_SIGNPOST.get()) {
            return POLISHED_BLACKSTONE_BRICKS_SIGN_TEXTURE;
        }
        if (block == SignpostBlocks.MOSSY_COBBLESTONE_SIGNPOST.get()) {
            return MOSSY_COBBLESTONE_SIGN_TEXTURE;
        }
        return OAK_SIGN_TEXTURE;
    }
}

