/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.customsignposts.tileentity;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.customsignposts.container.ContainerSignpost;
import net.pavocado.customsignposts.init.SignpostTileEntities;

public class TileEntitySignpost
extends TileEntity
implements INamedContainerProvider {
    public final ITextComponent[] signText = new ITextComponent[]{new StringTextComponent("Default Sign"), new StringTextComponent(""), new StringTextComponent(""), new StringTextComponent(""), new StringTextComponent(""), new StringTextComponent(""), new StringTextComponent("")};
    public final int[] angles = new int[]{90, 0, 0, 0, 0, 0, 0};
    public final BlockPos[] targets = new BlockPos[]{BlockPos.field_177992_a, BlockPos.field_177992_a, BlockPos.field_177992_a, BlockPos.field_177992_a, BlockPos.field_177992_a, BlockPos.field_177992_a, BlockPos.field_177992_a};
    public final byte[] signType = new byte[]{1, 0, 0, 0, 0, 0, 0};
    private final IReorderingProcessor[] renderText = new IReorderingProcessor[7];
    private DyeColor textColor = DyeColor.BLACK;
    public boolean isEditable = true;

    public TileEntitySignpost() {
        super((TileEntityType)SignpostTileEntities.TILEENTITY_SIGNPOST.get());
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("Color", this.textColor.func_176762_d());
        compound.func_74757_a("Editable", this.isEditable);
        for (int i = 0; i < 7; ++i) {
            String s = ITextComponent.Serializer.func_150696_a((ITextComponent)this.signText[i]);
            compound.func_74778_a("Text" + (i + 1), s);
            compound.func_74768_a("Angle" + (i + 1), this.angles[i]);
            int[] pos = new int[]{this.targets[i].func_177958_n(), this.targets[i].func_177956_o(), this.targets[i].func_177952_p()};
            compound.func_74783_a("Target" + (i + 1), pos);
            compound.func_74774_a("Type" + (i + 1), this.signType[i]);
        }
        return compound;
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        super.func_230337_a_(blockState, compound);
        this.textColor = DyeColor.func_204271_a((String)compound.func_74779_i("Color"), (DyeColor)DyeColor.BLACK);
        this.isEditable = compound.func_74767_n("Editable");
        for (int i = 0; i < 7; ++i) {
            String s = compound.func_74779_i("Text" + (i + 1));
            IFormattableTextComponent itextcomponent = ITextComponent.Serializer.func_240643_a_((String)(s.isEmpty() ? "\"\"" : s));
            this.signText[i] = itextcomponent;
            this.angles[i] = compound.func_74762_e("Angle" + (i + 1));
            int[] pos = compound.func_74759_k("Target" + (i + 1));
            this.targets[i] = new BlockPos(pos[0], pos[1], pos[2]);
            this.renderText[i] = null;
            this.signType[i] = compound.func_74771_c("Type" + (i + 1));
        }
    }

    public void setLine(int line, byte type, ITextComponent textComponent, int angle, BlockPos target) {
        this.signType[line] = type;
        this.angles[line] = angle;
        this.targets[line] = target;
        this.signText[line] = textComponent;
        this.renderText[line] = null;
    }

    public DyeColor getTextColor() {
        return this.textColor;
    }

    public boolean setTextColor(DyeColor newColor) {
        if (newColor != this.getTextColor()) {
            this.textColor = newColor;
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
            return true;
        }
        return false;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public IReorderingProcessor getRenderText(int line, Function<ITextComponent, IReorderingProcessor> stringFunction) {
        if (this.renderText[line] == null && this.signText[line] != null) {
            this.renderText[line] = stringFunction.apply(this.signText[line]);
        }
        return this.renderText[line];
    }

    @Nonnull
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return new ContainerSignpost(windowId, inventory, this);
    }

    public BlockPos getZeroPos() {
        return new BlockPos(this.field_174879_c.func_177958_n(), 0, this.field_174879_c.func_177952_p());
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("customsignposts.container.signpost");
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        if (pkt != null) {
            this.func_230337_a_(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        BlockPos pos = this.getTileEntity().func_174877_v();
        return new AxisAlignedBB(pos.func_177982_a(-1, 0, -1), pos.func_177982_a(2, 2, 2));
    }

    public static enum SignType {
        NONE,
        ANGLE,
        COORDINATE;


        public static SignType next(SignType signType) {
            if (signType == NONE) {
                return ANGLE;
            }
            if (signType == ANGLE) {
                return COORDINATE;
            }
            return NONE;
        }
    }
}

