/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigManager {
    private static final ForgeConfigSpec.Builder CFG = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec.BooleanValue SCAFFOLD;
    public static ForgeConfigSpec.BooleanValue EMERALD;
    public static ForgeConfigSpec.BooleanValue SANDSTONE;
    public static ForgeConfigSpec.BooleanValue GEMGEAR;
    public static ForgeConfigSpec.BooleanValue NETHERBRICK;
    public static ForgeConfigSpec.BooleanValue ENCHANTMENTS;
    public static ForgeConfigSpec.BooleanValue CHARMS;
    public static ForgeConfigSpec.BooleanValue GLOVE;
    public static ForgeConfigSpec.BooleanValue HEARTS;
    public static ForgeConfigSpec.BooleanValue CARROTS;
    public static ForgeConfigSpec.BooleanValue SPIKES;
    public static ForgeConfigSpec.BooleanValue BOOMERANGS;
    public static ForgeConfigSpec.BooleanValue CABLES;
    public static ForgeConfigSpec.IntValue ANVILPOWER;
    public static ForgeConfigSpec.IntValue MELTERPOWER;
    public static ForgeConfigSpec.IntValue SOLIDIFIERPOWER;
    public static ForgeConfigSpec.IntValue PEATERICHPOWER;
    public static ForgeConfigSpec.IntValue PEATPOWER;
    public static ForgeConfigSpec.IntValue HARVESTERPOWER;
    public static ForgeConfigSpec.IntValue DISENCHANTERPOWER;
    public static ForgeConfigSpec.DoubleValue PEATCHANCE;
    public static ForgeConfigSpec.BooleanValue COMMANDNBT;
    public static ForgeConfigSpec.BooleanValue COMMANDGETHOME;
    public static ForgeConfigSpec.BooleanValue COMMANDHEALTH;
    public static ForgeConfigSpec.BooleanValue COMMANDHOME;
    public static ForgeConfigSpec.BooleanValue COMMANDHUNGER;
    public static ForgeConfigSpec.BooleanValue COMMANDPINGNETHER;
    public static ForgeConfigSpec.BooleanValue COMMANDWORLDSPAWN;
    public static ForgeConfigSpec.BooleanValue COMMANDGETHELP;

    private static void initConfig() {
        CFG.comment("Feature toggles; each of these will disable the registration of some content (items/enchants)").push("cyclic");
        String category = "";
        CABLES = CFG.comment("Disable the cables aka pipes").define(category + "cables", true);
        BOOMERANGS = CFG.comment("Disable the 3 boomerang items").define(category + "boomerangs", true);
        SPIKES = CFG.comment("Disable the 3 spike blocks").define(category + "spikes", true);
        SCAFFOLD = CFG.comment("Disable the 3 scaffolding blocks").define(category + "scaffolding", true);
        CARROTS = CFG.comment("Disable the 5 carrot items that upgrade horses").define(category + "carrots", true);
        HEARTS = CFG.comment("Disable 2 heart items that increase and decrease max health").define(category + "hearts", true);
        GLOVE = CFG.comment("Disable the completely balanced climbing glove").define(category + "glove", true);
        CHARMS = CFG.comment("Disable 6 charms (four basic, the ultimate, and the anti-gravity)").define(category + "charms", true);
        EMERALD = CFG.comment("Disable 9 items, emerald armor and tools").define(category + "emeraldGear", true);
        SANDSTONE = CFG.comment("Disable 5 sandstone tools").define(category + "sandstoneGear", true);
        GEMGEAR = CFG.comment("Disable the endgame gear").define(category + "gemObsidianGear", true);
        NETHERBRICK = CFG.comment("Disable 5 netherbrick tools").define(category + "netherbrickGear", true);
        ENCHANTMENTS = CFG.comment("Disable all 11 enchantments").define(category + "enchantments", true);
        category = "energy.fuel.";
        PEATPOWER = CFG.comment("Power to repair one tick of durability").defineInRange(category + "peat_fuel", 256, 1, 64000);
        PEATERICHPOWER = CFG.comment("Power gained burning one of this").defineInRange(category + "peat_fuel_enriched", 1024, 1, 64000);
        category = "energy.cost.";
        DISENCHANTERPOWER = CFG.comment("Power gained burning one of this").defineInRange(category + "disenchanter", 1500, 1, 64000);
        ANVILPOWER = CFG.comment("Power gained burning one of this").defineInRange(category + "anvil", 250, 1, 64000);
        MELTERPOWER = CFG.comment("Power per recipe").defineInRange(category + "melter", 5000, 1, 64000);
        SOLIDIFIERPOWER = CFG.comment("Power per recipe").defineInRange(category + "solidifier", 5000, 1, 64000);
        HARVESTERPOWER = CFG.comment("Power per use").defineInRange(category + "harvester", 250, 1, 64000);
        category = "peat.";
        PEATCHANCE = CFG.comment("Chance that Peat Bog converts to Peat when wet (is multiplied by the number of surrounding water blocks)").defineInRange(category + " conversionChance", (double)0.08f, (double)0.001f, 1.0);
        category = "command.";
        COMMANDGETHOME = CFG.comment("True means only players with OP can use this /cyclic command").define(category + "gethome", false);
        COMMANDGETHELP = CFG.comment("True means only players with OP can use this /cyclic command").define(category + "help", false);
        COMMANDHEALTH = CFG.comment("True means only players with OP can use this /cyclic command").define(category + "health", true);
        COMMANDHOME = CFG.comment("True means only players with OP can use this /cyclic command").define(category + "home", true);
        COMMANDHUNGER = CFG.comment("True means only players with OP can use this /cyclic command").define(category + "hunger", true);
        COMMANDNBT = CFG.comment("True means only players with OP can use this /cyclic command").define(category + "nbtprint", false);
        COMMANDPINGNETHER = CFG.comment("True means only players with OP can use this /cyclic command").define(category + "pingnether", false);
        COMMANDWORLDSPAWN = CFG.comment("True means only players with OP can use this /cyclic command").define(category + "worldspawn", true);
        CFG.pop();
        COMMON_CONFIG = CFG.build();
    }

    public static void setup(Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        COMMON_CONFIG.setConfig((CommentedConfig)configData);
    }

    static {
        SCAFFOLD = null;
        ConfigManager.initConfig();
    }
}

