/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.util.UtilStuff;
import java.util.ArrayList;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.SoundType;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockSound
extends BlockBase {
    private static final int VOL_REDUCE_PER_BLOCK = 2;
    private static final int RADIUS = 6;

    public BlockSound(AbstractBlock.Properties properties) {
        super(properties.func_200943_b(1.8f).func_200947_a(SoundType.field_222470_q));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onPlaySound(PlaySoundEvent event) {
        if (event.getResultSound() == null || event.getResultSound() instanceof ITickableSound || ModCyclic.proxy.getClientWorld() == null) {
            return;
        }
        ISound sound = event.getResultSound();
        ArrayList<BlockPos> blocks = UtilStuff.findBlocks(ModCyclic.proxy.getClientWorld(), new BlockPos(sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i()), this, 6);
        if (blocks == null || blocks.size() == 0) {
            return;
        }
        try {
            SoundVolumeControlled newSound = new SoundVolumeControlled(sound);
            float pct = 0.33333334f;
            newSound.setVolume((float)(Math.min((double)pct, 1.0) / (double)blocks.size()));
            event.setResultSound((ISound)newSound);
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("Error trying to detect volume of sound from 3rd party ", (Throwable)e);
        }
    }

    private static class SoundVolumeControlled
    implements ISound {
        public float volume;
        public ISound sound;

        public SoundVolumeControlled(ISound s) {
            this.sound = s;
        }

        public void setVolume(float v) {
            this.volume = v;
        }

        public float func_147653_e() {
            return this.volume * this.sound.func_147653_e();
        }

        public ResourceLocation func_147650_b() {
            return this.sound.func_147650_b();
        }

        public SoundEventAccessor func_184366_a(SoundHandler handler) {
            return this.sound.func_184366_a(handler);
        }

        public Sound func_184364_b() {
            return this.sound.func_184364_b();
        }

        public SoundCategory func_184365_d() {
            return this.sound.func_184365_d();
        }

        public boolean func_147657_c() {
            return this.sound.func_147657_c();
        }

        public int func_147652_d() {
            return this.sound.func_147652_d();
        }

        public float func_147655_f() {
            return this.sound.func_147655_f();
        }

        public ISound.AttenuationType func_147656_j() {
            return this.sound.func_147656_j();
        }

        public boolean func_217861_m() {
            return this.sound.func_217861_m();
        }

        public double func_147649_g() {
            return this.sound.func_147649_g();
        }

        public double func_147654_h() {
            return this.sound.func_147654_h();
        }

        public double func_147651_i() {
            return this.sound.func_147651_i();
        }
    }
}

