/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable.fluid;

import com.google.common.collect.Maps;
import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.cable.CableBase;
import com.lothrazar.cyclic.block.cable.DirectionNullable;
import com.lothrazar.cyclic.block.cable.fluid.BlockCableFluid;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.UtilFluid;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileCableFluid
extends TileEntityBase
implements ITickableTileEntity {
    public static final int CAPACITY = 16000;
    public static final int TRANSFER_FLUID_PER_TICK = 500;
    private Map<Direction, LazyOptional<IFluidHandler>> flow = Maps.newHashMap();
    List<Integer> rawList = IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList());

    public TileCableFluid() {
        super(BlockRegistry.Tiles.fluid_pipeTile);
        for (Direction f : Direction.values()) {
            this.flow.put(f, (LazyOptional<IFluidHandler>)LazyOptional.of(this::createHandler));
        }
    }

    private IFluidHandler createHandler() {
        FluidTankBase h = new FluidTankBase(this, 16000, this.isFluidValid());
        return h;
    }

    public Predicate<FluidStack> isFluidValid() {
        return p -> true;
    }

    public void func_73660_a() {
        this.tryExtract();
        this.normalFlow();
    }

    private void tryExtract() {
        Direction extractSide = ((DirectionNullable)((Object)this.func_195044_w().func_177229_b((Property)BlockCableFluid.EXTR))).direction();
        if (extractSide == null) {
            return;
        }
        BlockPos target = this.field_174879_c.func_177972_a(extractSide);
        UtilFluid.tryFillPositionFromTank(this.field_145850_b, this.field_174879_c, extractSide, UtilFluid.getTank(this.field_145850_b, target, extractSide.func_176734_d()), 16000);
    }

    private void normalFlow() {
        Direction importFromSide = ((DirectionNullable)((Object)this.func_195044_w().func_177229_b((Property)BlockCableFluid.EXTR))).direction();
        for (Direction incomingSide : Direction.values()) {
            IFluidHandler sideHandler = (IFluidHandler)this.flow.get(incomingSide).orElse(null);
            Collections.shuffle(this.rawList);
            for (Integer i : this.rawList) {
                Direction outgoingSide = Direction.values()[i];
                if (outgoingSide == incomingSide || importFromSide != null && importFromSide == outgoingSide) continue;
                this.moveFluids(outgoingSide, 16000, sideHandler);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (side != null && cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && !CableBase.isCableBlocked(this.func_195044_w(), side)) {
            return this.flow.get(side).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        for (Direction dir : Direction.values()) {
            FluidTankBase fluidh = (FluidTankBase)((Object)this.flow.get(dir).orElse(null));
            if (!tag.func_74764_b("fluid" + dir.toString())) continue;
            fluidh.readFromNBT(tag.func_74775_l("fluid" + dir.toString()));
        }
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        for (Direction dir : Direction.values()) {
            FluidTankBase fluidh = (FluidTankBase)((Object)this.flow.get(dir).orElse(null));
            CompoundNBT fluidtag = new CompoundNBT();
            if (fluidh != null) {
                fluidh.writeToNBT(fluidtag);
            }
            tag.func_218657_a("fluid" + dir.toString(), (INBT)fluidtag);
        }
        return super.func_189515_b(tag);
    }

    @Override
    public void setField(int field, int value) {
    }
}

