/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable.item;

import com.lothrazar.cyclic.block.cable.CableBase;
import com.lothrazar.cyclic.block.cable.DirectionNullable;
import com.lothrazar.cyclic.block.cable.EnumConnectType;
import com.lothrazar.cyclic.block.cable.item.TileCableItem;
import com.lothrazar.cyclic.util.UtilItemStack;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockCableItem
extends CableBase {
    public BlockCableItem(AbstractBlock.Properties properties) {
        super(properties.func_200943_b(0.5f));
    }

    private boolean shapeConnects(BlockState state, EnumProperty<EnumConnectType> dirctionProperty) {
        return ((EnumConnectType)((Object)state.func_177229_b(dirctionProperty))).equals((Object)EnumConnectType.INVENTORY);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape = AABB;
        if (this.shapeConnects(state, (EnumProperty<EnumConnectType>)UP)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_UP, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (this.shapeConnects(state, (EnumProperty<EnumConnectType>)DOWN)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_DOWN, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (((EnumConnectType)((Object)state.func_177229_b((Property)WEST))).equals((Object)EnumConnectType.INVENTORY)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_WEST, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (((EnumConnectType)((Object)state.func_177229_b((Property)EAST))).equals((Object)EnumConnectType.INVENTORY)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_EAST, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (((EnumConnectType)((Object)state.func_177229_b((Property)NORTH))).equals((Object)EnumConnectType.INVENTORY)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_NORTH, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (((EnumConnectType)((Object)state.func_177229_b((Property)SOUTH))).equals((Object)EnumConnectType.INVENTORY)) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)AABB_SOUTH, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return shape;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            for (Direction d : Direction.values()) {
                IItemHandler items = (IItemHandler)tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, d).orElse(null);
                UtilItemStack.dropAll(items, worldIn, pos);
            }
            worldIn.func_175666_e(pos, (Block)this);
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileCableItem();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{UP, DOWN, NORTH, EAST, SOUTH, WEST, EXTR});
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState stateIn, @Nullable LivingEntity placer, ItemStack stack) {
        stateIn = (BlockState)stateIn.func_206870_a((Property)EXTR, (Comparable)((Object)DirectionNullable.NONE));
        for (Direction d : Direction.values()) {
            IItemHandler cap;
            TileEntity facingTile = worldIn.func_175625_s(pos.func_177972_a(d));
            IItemHandler iItemHandler = cap = facingTile == null ? null : (IItemHandler)facingTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, d.func_176734_d()).orElse(null);
            if (cap == null) continue;
            stateIn = (BlockState)stateIn.func_206870_a((Property)FACING_TO_PROPERTY_MAP.get(d), (Comparable)((Object)EnumConnectType.INVENTORY));
        }
        worldIn.func_175656_a(pos, stateIn);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        EnumProperty property = (EnumProperty)FACING_TO_PROPERTY_MAP.get(facing);
        if (((EnumConnectType)((Object)stateIn.func_177229_b((Property)property))).isBlocked()) {
            return stateIn;
        }
        if (BlockCableItem.isItem(stateIn, facing, facingState, world, currentPos, facingPos)) {
            return (BlockState)stateIn.func_206870_a((Property)property, (Comparable)((Object)EnumConnectType.INVENTORY));
        }
        return (BlockState)stateIn.func_206870_a((Property)property, (Comparable)((Object)EnumConnectType.NONE));
    }
}

