/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.collectitem;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.collectitem.ContainerCollector;
import com.lothrazar.cyclic.registry.BlockRegistry;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileCollector
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    private int radius = 8;
    private LazyOptional<IItemHandler> handler = LazyOptional.of(this::createHandler);

    public TileCollector() {
        super(BlockRegistry.Tiles.collectortile);
        this.setNeedsRedstone(1);
    }

    private IItemHandler createHandler() {
        return new ItemStackHandler(18);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerCollector(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.radius = tag.func_74762_e("radius");
        CompoundNBT invTag = tag.func_74775_l("inv");
        this.handler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)invTag));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("radius", this.radius);
        this.handler.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        return super.func_189515_b(tag);
    }

    private BlockPos getTargetCenter() {
        return this.func_174877_v().func_177967_a(this.getCurrentFacing(), this.radius);
    }

    private Direction getCurrentFacing() {
        return (Direction)this.func_195044_w().func_177229_b((Property)HorizontalBlock.field_185512_D);
    }

    public void func_73660_a() {
        if (this.requiresRedstone() && !this.isPowered()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockPos center = this.getTargetCenter();
        List list = this.field_145850_b.func_175647_a(ItemEntity.class, new AxisAlignedBB((double)(center.func_177958_n() - this.radius), (double)center.func_177956_o(), (double)(center.func_177952_p() - this.radius), (double)(center.func_177958_n() + this.radius), (double)(center.func_177956_o() + 2), (double)(center.func_177952_p() + this.radius)), entity -> entity.func_70089_S());
        if (list.size() > 0) {
            ItemEntity stackEntity = (ItemEntity)list.get(this.field_145850_b.field_73012_v.nextInt(list.size()));
            IItemHandler h = (IItemHandler)this.handler.orElse(null);
            ItemStack remainder = stackEntity.func_92059_d();
            for (int i = 0; i < h.getSlots() && !remainder.func_190926_b(); ++i) {
                remainder = h.insertItem(i, remainder, false);
            }
            stackEntity.func_92058_a(remainder);
            if (remainder.func_190926_b()) {
                stackEntity.func_70106_y();
            }
        }
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.setNeedsRedstone(value);
            }
        }
    }

    public static enum Fields {
        REDSTONE;

    }
}

