/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.expcollect;

import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.expcollect.ContainerExpPylon;
import com.lothrazar.cyclic.fluid.FluidXpJuiceHolder;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.UtilEntity;
import com.lothrazar.cyclic.util.UtilSound;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileExpPylon
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    public static final int FLUID_PER_EXP = 20;
    public static final int DRAIN_PLAYER_EXP = 20;
    public static final int EXP_PER_BOTTLE = 11;
    private static final int RADIUS = 16;
    public static final int CAPACITY = 64000000;
    public FluidTankBase tank = new FluidTankBase(this, 64000000, this.isFluidValid());

    public TileExpPylon() {
        super(BlockRegistry.Tiles.experience_pylontile);
    }

    public Predicate<FluidStack> isFluidValid() {
        return p -> p.getFluid() == FluidXpJuiceHolder.STILL.get();
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.tank).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.tank.readFromNBT(tag.func_74775_l("fluid"));
        int legacy = tag.func_74762_e("storedXp");
        if (legacy > 0) {
            this.tank.setFluid(new FluidStack((Fluid)FluidXpJuiceHolder.STILL.get(), legacy * 20));
        }
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT fluid = new CompoundNBT();
        this.tank.writeToNBT(fluid);
        tag.func_218657_a("fluid", (INBT)fluid);
        tag.func_74768_a("storedXp", this.getStoredXp());
        return super.func_189515_b(tag);
    }

    public void func_73660_a() {
        if (this.requiresRedstone() && !this.isPowered()) {
            return;
        }
        this.collectLocalExperience();
        if (!this.field_145850_b.field_72995_K) {
            this.collectPlayerExperience();
        }
    }

    private void collectPlayerExperience() {
        List players = this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB(this.func_174877_v().func_177984_a()));
        for (PlayerEntity p : players) {
            double myTotal = UtilEntity.getExpTotal(p);
            if (!p.func_213453_ef() || !(myTotal > 0.0)) continue;
            int addMeXp = 1;
            int addMeFluid = addMeXp * 20;
            if (this.tank.getFluidAmount() + addMeFluid > this.tank.getCapacity()) continue;
            p.func_195068_e(-1 * addMeXp);
            this.tank.fill(new FluidStack((Fluid)FluidXpJuiceHolder.STILL.get(), addMeFluid), IFluidHandler.FluidAction.EXECUTE);
            UtilSound.playSound(p, SoundEvents.field_187604_bf);
            this.func_70296_d();
        }
    }

    private void collectLocalExperience() {
        List list = this.field_145850_b.func_175647_a(ExperienceOrbEntity.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 16), (double)(this.field_174879_c.func_177956_o() - 1), (double)(this.field_174879_c.func_177952_p() - 16), (double)(this.field_174879_c.func_177958_n() + 16), (double)(this.field_174879_c.func_177956_o() + 2), (double)(this.field_174879_c.func_177952_p() + 16)), entity -> entity.func_70089_S() && entity.func_70526_d() > 0);
        if (list.size() > 0) {
            ExperienceOrbEntity myOrb = (ExperienceOrbEntity)list.get(this.field_145850_b.field_73012_v.nextInt(list.size()));
            int addMeXp = myOrb.func_70526_d();
            if (this.getStoredXp() + addMeXp <= this.tank.getCapacity()) {
                myOrb.field_70530_e = 0;
                myOrb.func_70106_y();
                int addMeFluid = addMeXp * 20;
                this.tank.fill(new FluidStack((Fluid)FluidXpJuiceHolder.STILL.get(), addMeFluid), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    public int getStoredXp() {
        return this.tank.getFluidAmount() / 20;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.setNeedsRedstone(value);
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.getNeedsRedstone();
            }
        }
        return 0;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerExpPylon(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public static enum Fields {
        REDSTONE;

    }
}

