/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.fishing;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.UtilItemStack;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileFisher
extends TileEntityBase
implements ITickableTileEntity {
    private static final int RADIUS = 12;
    public static final ITag.INamedTag<Item> RODS = ItemTags.func_199901_a((String)new ResourceLocation("cyclic", "fishing_rods").toString());
    private static final double CHANCE = 0.1;
    LazyOptional<IItemHandler> inventory = LazyOptional.of(this::createHandler);

    public TileFisher() {
        super(BlockRegistry.Tiles.fisher);
    }

    private IItemHandler createHandler() {
        return new ItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.func_77973_b().func_206844_a(RODS);
            }
        };
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.inventory.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("inv")));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.inventory.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        return super.func_189515_b(tag);
    }

    public void func_73660_a() {
        this.inventory.ifPresent(inv -> {
            int z;
            int y;
            int x;
            BlockPos center;
            ItemStack stack = inv.getStackInSlot(0);
            if (stack.func_77973_b().func_206844_a(RODS) && this.isWater(center = new BlockPos(x = this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextInt(24) - 12, y = this.field_174879_c.func_177956_o(), z = this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextInt(24) - 12))) {
                try {
                    this.doFishing(stack, center);
                }
                catch (Exception e) {
                    ModCyclic.LOGGER.error("Loot table failed", (Throwable)e);
                }
            }
        });
    }

    private boolean isWater(BlockPos center) {
        return this.field_145850_b.func_180495_p(center).func_177230_c() == Blocks.field_150355_j;
    }

    private void doFishing(ItemStack fishingRod, BlockPos center) {
        World world = this.func_145831_w();
        Random rand = world.field_73012_v;
        if (rand.nextDouble() < 0.1 && world instanceof ServerWorld) {
            LootTableManager manager = world.func_73046_m().func_200249_aQ();
            if (manager == null) {
                return;
            }
            LootTable table = manager.func_186521_a(LootTables.field_186387_al);
            if (table == null) {
                return;
            }
            int luck = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_151370_z, (ItemStack)fishingRod) + 1;
            LootContext lootContext = new LootContext.Builder((ServerWorld)world).func_186469_a((float)luck).func_216023_a(rand).func_216015_a(LootParameters.field_216286_f, (Object)center).func_216015_a(LootParameters.field_216289_i, (Object)fishingRod).func_216022_a(LootParameterSets.field_216262_c);
            List lootDrops = table.func_216113_a(lootContext);
            if (lootDrops != null && lootDrops.size() > 0) {
                UtilItemStack.damageItem(fishingRod);
                UtilItemStack.drop(world, center, lootDrops);
            }
        }
    }

    @Override
    public void setField(int field, int value) {
    }
}

