/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.placerfluid;

import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.placerfluid.ContainerPlacerFluid;
import com.lothrazar.cyclic.registry.BlockRegistry;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TilePlacerFluid
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    public static final int CAPACITY = 8000;
    FluidTankBase tank;
    private final LazyOptional<FluidTankBase> tankWrapper = LazyOptional.of(() -> this.tank);

    public TilePlacerFluid() {
        super(BlockRegistry.Tiles.placer_fluid);
        this.tank = new FluidTankBase(this, 8000, this.isFluidValid());
        this.needsRedstone = 1;
    }

    public Predicate<FluidStack> isFluidValid() {
        return p -> true;
    }

    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerPlacerFluid(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankWrapper.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.tank.readFromNBT(tag.func_74775_l("fluid"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT fluid = new CompoundNBT();
        this.tank.writeToNBT(fluid);
        tag.func_218657_a("fluid", (INBT)fluid);
        return super.func_189515_b(tag);
    }

    public void func_73660_a() {
        if (this.requiresRedstone() && !this.isPowered()) {
            return;
        }
        FluidStack test = this.tank.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        if (test.getAmount() == 1000 && test.getFluid().func_207188_f() != null && test.getFluid().func_207188_f().func_206883_i() != null) {
            Direction dir = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
            BlockPos offset = this.field_174879_c.func_177972_a(dir);
            BlockState state = test.getFluid().func_207188_f().func_206883_i();
            if (this.field_145850_b.func_175623_d(offset) && this.field_145850_b.func_175656_a(offset, state)) {
                this.tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.setNeedsRedstone(value);
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.getNeedsRedstone();
            }
        }
        return 0;
    }

    public static enum Fields {
        REDSTONE;

    }
}

